/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class SvcTestCaseFactory {
    private SvcTestCaseFactory() {
    }

    public static Network create() {
        return SvcTestCaseFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("svcTestCase", "code");
        network.setCaseDate(ZonedDateTime.parse("2016-06-29T14:54:03.427+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vl1.newGenerator().setId("G1")).setConnectableBus("B1")).setBus("B1")).setVoltageRegulatorOn(true).setTargetP(100.0).setTargetV(400.0).setMinP(50.0).setMaxP(150.0).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).setCountry(Country.FR).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("VL2")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("L2")).setConnectableBus("B2")).setBus("B2")).setP0(100.0).setQ0(50.0).add();
        ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)vl2.newStaticVarCompensator().setId("SVC2")).setConnectableBus("B2")).setBus("B2")).setBmin(2.0E-4).setBmax(8.0E-4).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setRegulating(true).setVoltageSetpoint(390.0).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("L1")).setVoltageLevel1("VL1")).setConnectableBus1("B1")).setBus1("B1")).setVoltageLevel2("VL2")).setConnectableBus2("B2")).setBus2("B2")).setR(4.0).setX(200.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
        return network;
    }

    public static Network createWithMoreSVCs() {
        return SvcTestCaseFactory.createWithMoreSVCs(NetworkFactory.findDefault());
    }

    public static Network createWithMoreSVCs(NetworkFactory networkFactory) {
        Network network = SvcTestCaseFactory.create(networkFactory);
        ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)network.getVoltageLevel("VL2").newStaticVarCompensator().setId("SVC3")).setConnectableBus("B2")).setBus("B2")).setBmin(2.0E-4).setBmax(8.0E-4).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setRegulating(true).setVoltageSetpoint(390.0).setReactivePowerSetpoint(350.0).add();
        return network;
    }

    public static Network createWithRemoteRegulatingTerminal() {
        return SvcTestCaseFactory.createWithRemoteRegulatingTerminal(NetworkFactory.findDefault());
    }

    public static Network createWithRemoteRegulatingTerminal(NetworkFactory networkFactory) {
        Network network = SvcTestCaseFactory.create(networkFactory);
        network.getStaticVarCompensator("SVC2").setRegulatingTerminal(network.getLoad("L2").getTerminal());
        return network;
    }

    private static Network addReactiveTarget(Network network) {
        network.getStaticVarCompensator("SVC2").setReactivePowerSetpoint(350.0);
        return network;
    }

    private static Network addVoltageTarget(Network network) {
        network.getStaticVarCompensator("SVC2").setVoltageSetpoint(390.0);
        return network;
    }

    private static Network addBothTarget(Network network) {
        network.getStaticVarCompensator("SVC2").setReactivePowerSetpoint(350.0).setVoltageSetpoint(390.0);
        return network;
    }

    private static Network createLocalVoltageControl(Network network) {
        return SvcTestCaseFactory.addVoltageControl(network);
    }

    public static Network createLocalVoltageControl() {
        return SvcTestCaseFactory.createLocalVoltageControl(SvcTestCaseFactory.create());
    }

    public static Network createRemoteVoltageControl() {
        return SvcTestCaseFactory.createLocalVoltageControl(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network addVoltageControl(Network network) {
        SvcTestCaseFactory.addVoltageTarget(network);
        network.getStaticVarCompensator("SVC2").setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setRegulating(true);
        return network;
    }

    private static Network createReactiveControl(Network network) {
        return SvcTestCaseFactory.addReactiveControl(network);
    }

    public static Network createLocalReactiveControl() {
        return SvcTestCaseFactory.createReactiveControl(SvcTestCaseFactory.create());
    }

    public static Network createRemoteReactiveControl() {
        return SvcTestCaseFactory.createReactiveControl(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network addReactiveControl(Network network) {
        SvcTestCaseFactory.addReactiveTarget(network);
        network.getStaticVarCompensator("SVC2").setRegulationMode(StaticVarCompensator.RegulationMode.REACTIVE_POWER).setRegulating(true);
        return network;
    }

    public static Network createLocalOffReactiveTarget() {
        return SvcTestCaseFactory.createOffReactiveTarget(SvcTestCaseFactory.create());
    }

    public static Network createRemoteOffReactiveTarget() {
        return SvcTestCaseFactory.createOffReactiveTarget(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network createOffReactiveTarget(Network network) {
        return SvcTestCaseFactory.addOffReactiveTarget(network);
    }

    private static Network addOffReactiveTarget(Network network) {
        SvcTestCaseFactory.addReactiveTarget(SvcTestCaseFactory.addNotRegulating(network));
        network.getStaticVarCompensator("SVC2").setRegulationMode(StaticVarCompensator.RegulationMode.REACTIVE_POWER).setRegulating(true);
        return network;
    }

    public static Network createLocalOffVoltageTarget() {
        return SvcTestCaseFactory.createOffVoltageTarget(SvcTestCaseFactory.create());
    }

    public static Network createRemoteOffVoltageTarget() {
        return SvcTestCaseFactory.createOffVoltageTarget(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network createOffVoltageTarget(Network network) {
        return SvcTestCaseFactory.addOffVoltageTarget(network);
    }

    private static Network addOffVoltageTarget(Network network) {
        return SvcTestCaseFactory.addVoltageTarget(SvcTestCaseFactory.addNotRegulating(network));
    }

    public static Network createLocalOffBothTarget() {
        return SvcTestCaseFactory.createOffBothTarget(SvcTestCaseFactory.create());
    }

    public static Network createRemoteOffBothTarget() {
        return SvcTestCaseFactory.createOffBothTarget(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network createOffBothTarget(Network network) {
        return SvcTestCaseFactory.addOffBothTarget(network);
    }

    private static Network addOffBothTarget(Network network) {
        return SvcTestCaseFactory.addBothTarget(SvcTestCaseFactory.addNotRegulating(network));
    }

    public static Network createLocalOffNoTarget() {
        return SvcTestCaseFactory.addNotRegulating(SvcTestCaseFactory.create());
    }

    public static Network createRemoteOffNoTarget() {
        return SvcTestCaseFactory.addNotRegulating(SvcTestCaseFactory.createWithRemoteRegulatingTerminal());
    }

    private static Network addNotRegulating(Network network) {
        network.getStaticVarCompensator("SVC2").setRegulating(false).setRegulationMode(StaticVarCompensator.RegulationMode.VOLTAGE).setVoltageSetpoint(Double.NaN).setReactivePowerSetpoint(Double.NaN);
        return network;
    }
}

