/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.xml.AbstractIdentifiableXml;
import com.powsybl.iidm.xml.AliasesXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.PropertiesXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;

abstract class AbstractComplexIdentifiableXml<T extends Identifiable<T>, A extends IdentifiableAdder<T, A>, P extends Identifiable>
extends AbstractIdentifiableXml<T, A, P> {
    AbstractComplexIdentifiableXml() {
    }

    protected abstract void readRootElementAttributes(A var1, List<Consumer<T>> var2, NetworkXmlReaderContext var3);

    protected void readSubElements(String id, List<Consumer<T>> toApply, NetworkXmlReaderContext context) throws XMLStreamException {
        if (context.getReader().getLocalName().equals("property")) {
            PropertiesXml.read(toApply, context);
        } else if (context.getReader().getLocalName().equals("alias")) {
            IidmXmlUtil.assertMinimumVersion(this.getRootElementName(), "alias", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
            AliasesXml.read(toApply, context);
        } else {
            throw new PowsyblException("Unknown element name <" + context.getReader().getLocalName() + "> in <" + id + ">");
        }
    }

    protected abstract void readSubElements(String var1, A var2, List<Consumer<T>> var3, NetworkXmlReaderContext var4) throws XMLStreamException;

    @Override
    public final void read(P parent, NetworkXmlReaderContext context) throws XMLStreamException {
        ArrayList<Consumer<Consumer>> toApply = new ArrayList<Consumer<Consumer>>();
        Object adder = this.createAdder(parent);
        String id = this.readIdentifierAttributes(adder, context);
        this.readRootElementAttributes(adder, toApply, context);
        this.readSubElements(id, adder, toApply, context);
        Identifiable identifiable = adder.add();
        toApply.forEach(consumer -> consumer.accept(identifiable));
    }
}

