/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.xml.AliasesXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.PropertiesXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

abstract class AbstractIdentifiableXml<T extends Identifiable<? super T>, A extends IdentifiableAdder<T, A>, P extends Identifiable> {
    AbstractIdentifiableXml() {
    }

    protected abstract String getRootElementName();

    protected abstract boolean hasSubElements(T var1);

    protected boolean hasSubElements(T identifiable, NetworkXmlWriterContext context) {
        return this.hasSubElements(identifiable);
    }

    protected boolean isValid(T identifiable, P parent) {
        return true;
    }

    protected abstract void writeRootElementAttributes(T var1, P var2, NetworkXmlWriterContext var3) throws XMLStreamException;

    protected void writeSubElements(T identifiable, P parent, NetworkXmlWriterContext context) throws XMLStreamException {
    }

    public final void write(T identifiable, P parent, NetworkXmlWriterContext context) throws XMLStreamException {
        boolean isNotEmptyElement;
        if (!this.isValid(identifiable, parent)) {
            return;
        }
        boolean bl = isNotEmptyElement = this.hasSubElements(identifiable, context) || identifiable.hasProperty() || identifiable.hasAliases();
        if (isNotEmptyElement) {
            context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), this.getRootElementName());
        } else {
            context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), this.getRootElementName());
        }
        context.getWriter().writeAttribute("id", context.getAnonymizer().anonymizeString(identifiable.getId()));
        identifiable.getOptionalName().ifPresent(name -> {
            try {
                context.getWriter().writeAttribute("name", context.getAnonymizer().anonymizeString((String)name));
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> XmlUtil.writeOptionalBoolean((String)"fictitious", (boolean)identifiable.isFictitious(), (boolean)false, (XMLStreamWriter)context.getWriter()));
        this.writeRootElementAttributes(identifiable, parent, context);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
            try {
                AliasesXml.write(identifiable, this.getRootElementName(), context);
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
        PropertiesXml.write(identifiable, context);
        this.writeSubElements(identifiable, parent, context);
        if (isNotEmptyElement) {
            context.getWriter().writeEndElement();
        }
        context.addExportedEquipment((Identifiable<?>)identifiable);
    }

    protected abstract A createAdder(P var1);

    public abstract void read(P var1, NetworkXmlReaderContext var2) throws XMLStreamException;

    protected String readIdentifierAttributes(A adder, NetworkXmlReaderContext context) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
        String name = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "name"));
        adder.setId(id).setName(name);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> {
            boolean fictitious = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)"fictitious", (boolean)false);
            adder.setFictitious(fictitious);
        });
        return id;
    }

    protected void readUntilEndRootElement(XMLStreamReader reader, XmlUtil.XmlEventHandler eventHandler) throws XMLStreamException {
        XmlUtil.readUntilEndElement((String)this.getRootElementName(), (XMLStreamReader)reader, (XmlUtil.XmlEventHandler)eventHandler);
    }
}

