/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.TapChangerStep;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.function.BiConsumer;
import java.util.function.DoubleConsumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

abstract class AbstractTransformerXml<T extends Connectable<T>, A extends IdentifiableAdder<T, A>>
extends AbstractSimpleIdentifiableXml<T, A, Substation> {
    private static final String ATTR_LOW_TAP_POSITION = "lowTapPosition";
    private static final String ATTR_TAP_POSITION = "tapPosition";
    private static final String ATTR_REGULATING = "regulating";
    private static final String ELEM_TERMINAL_REF = "terminalRef";
    private static final String ELEM_STEP = "step";
    private static final String TARGET_DEADBAND = "targetDeadband";
    private static final String RATIO_TAP_CHANGER = "ratioTapChanger";
    private static final String PHASE_TAP_CHANGER = "phaseTapChanger";

    AbstractTransformerXml() {
    }

    protected static void writeTapChangerStep(TapChangerStep<?> tcs, XMLStreamWriter writer) throws XMLStreamException {
        XmlUtil.writeDouble((String)"r", (double)tcs.getR(), (XMLStreamWriter)writer);
        XmlUtil.writeDouble((String)"x", (double)tcs.getX(), (XMLStreamWriter)writer);
        XmlUtil.writeDouble((String)"g", (double)tcs.getG(), (XMLStreamWriter)writer);
        XmlUtil.writeDouble((String)"b", (double)tcs.getB(), (XMLStreamWriter)writer);
        XmlUtil.writeDouble((String)"rho", (double)tcs.getRho(), (XMLStreamWriter)writer);
    }

    private static void writeTargetDeadband(double targetDeadband, NetworkXmlWriterContext context) {
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> XmlUtil.writeOptionalDouble((String)TARGET_DEADBAND, (double)targetDeadband, (double)0.0, (XMLStreamWriter)context.getWriter()));
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> XmlUtil.writeDouble((String)TARGET_DEADBAND, (double)targetDeadband, (XMLStreamWriter)context.getWriter()));
    }

    private static double readTargetDeadband(NetworkXmlReaderContext context) {
        double[] targetDeadband = new double[1];
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> {
            targetDeadband[0] = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)TARGET_DEADBAND);
            if (Boolean.parseBoolean(context.getReader().getAttributeValue(null, ATTR_REGULATING)) && Double.isNaN(targetDeadband[0])) {
                targetDeadband[0] = 0.0;
            }
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> {
            targetDeadband[0] = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)TARGET_DEADBAND);
        });
        return targetDeadband[0];
    }

    private static void writeTapChanger(TapChanger<?, ?> tc, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute(ATTR_LOW_TAP_POSITION, Integer.toString(tc.getLowTapPosition()));
        if (tc.findTapPosition().isPresent()) {
            context.getWriter().writeAttribute(ATTR_TAP_POSITION, Integer.toString(tc.getTapPosition()));
        }
        AbstractTransformerXml.writeTargetDeadband(tc.getTargetDeadband(), context);
    }

    protected static void writeRatioTapChanger(String name, RatioTapChanger rtc, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), name);
        AbstractTransformerXml.writeTapChanger(rtc, context);
        context.getWriter().writeAttribute("loadTapChangingCapabilities", Boolean.toString(rtc.hasLoadTapChangingCapabilities()));
        if (rtc.hasLoadTapChangingCapabilities() || rtc.isRegulating()) {
            context.getWriter().writeAttribute(ATTR_REGULATING, Boolean.toString(rtc.isRegulating()));
        }
        XmlUtil.writeDouble((String)"targetV", (double)rtc.getTargetV(), (XMLStreamWriter)context.getWriter());
        if (rtc.getRegulationTerminal() != null) {
            TerminalRefXml.writeTerminalRef(rtc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        }
        for (int p = rtc.getLowTapPosition(); p <= rtc.getHighTapPosition(); ++p) {
            RatioTapChangerStep rtcs = (RatioTapChangerStep)rtc.getStep(p);
            context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), ELEM_STEP);
            AbstractTransformerXml.writeTapChangerStep(rtcs, context.getWriter());
        }
        context.getWriter().writeEndElement();
    }

    protected static void readRatioTapChanger(String elementName, RatioTapChangerAdder adder, Terminal terminal, NetworkXmlReaderContext context) throws XMLStreamException {
        int lowTapPosition = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)ATTR_LOW_TAP_POSITION);
        double targetDeadband = AbstractTransformerXml.readTargetDeadband(context);
        boolean loadTapChangingCapabilities = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"loadTapChangingCapabilities");
        double targetV = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetV");
        adder.setLowTapPosition(lowTapPosition).setTargetDeadband(targetDeadband).setLoadTapChangingCapabilities(loadTapChangingCapabilities).setTargetV(targetV);
        XmlUtil.consumeOptionalIntAttribute((XMLStreamReader)context.getReader(), (String)ATTR_TAP_POSITION, arg_0 -> ((RatioTapChangerAdder)adder).setTapPosition(arg_0));
        XmlUtil.consumeOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)ATTR_REGULATING, arg_0 -> ((RatioTapChangerAdder)adder).setRegulating(arg_0));
        boolean[] hasTerminalRef = new boolean[1];
        XmlUtil.readUntilEndElement((String)elementName, (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "terminalRef": {
                    AbstractTransformerXml.readTerminalRef(context, hasTerminalRef, (id, side) -> {
                        adder.setRegulationTerminal(TerminalRefXml.resolve(id, side, terminal.getVoltageLevel().getNetwork()));
                        adder.add();
                    });
                    break;
                }
                case "step": {
                    AbstractTransformerXml.readSteps(context, (r, x, g, b, rho) -> adder.beginStep().setR(r).setX(x).setG(g).setB(b).setRho(rho).endStep());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    protected static void readRatioTapChanger(TwoWindingsTransformer twt, NetworkXmlReaderContext context) throws XMLStreamException {
        AbstractTransformerXml.readRatioTapChanger(RATIO_TAP_CHANGER, twt.newRatioTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readRatioTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkXmlReaderContext context) throws XMLStreamException {
        AbstractTransformerXml.readRatioTapChanger(RATIO_TAP_CHANGER + leg, twl.newRatioTapChanger(), twl.getTerminal(), context);
    }

    protected static void writePhaseTapChanger(String name, PhaseTapChanger ptc, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), name);
        AbstractTransformerXml.writeTapChanger(ptc, context);
        XmlUtil.writeOptionalEnum((String)"regulationMode", (Enum)ptc.getRegulationMode(), (XMLStreamWriter)context.getWriter());
        if (ptc.getRegulationMode() != null && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP || !Double.isNaN(ptc.getRegulationValue())) {
            XmlUtil.writeDouble((String)"regulationValue", (double)ptc.getRegulationValue(), (XMLStreamWriter)context.getWriter());
        }
        if (ptc.getRegulationMode() != null && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP || ptc.isRegulating()) {
            context.getWriter().writeAttribute(ATTR_REGULATING, Boolean.toString(ptc.isRegulating()));
        }
        if (ptc.getRegulationTerminal() != null) {
            TerminalRefXml.writeTerminalRef(ptc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        }
        for (int p = ptc.getLowTapPosition(); p <= ptc.getHighTapPosition(); ++p) {
            PhaseTapChangerStep ptcs = (PhaseTapChangerStep)ptc.getStep(p);
            context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), ELEM_STEP);
            AbstractTransformerXml.writeTapChangerStep(ptcs, context.getWriter());
            XmlUtil.writeDouble((String)"alpha", (double)ptcs.getAlpha(), (XMLStreamWriter)context.getWriter());
        }
        context.getWriter().writeEndElement();
    }

    protected static void readPhaseTapChanger(String name, PhaseTapChangerAdder adder, Terminal terminal, NetworkXmlReaderContext context) throws XMLStreamException {
        int lowTapPosition = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)ATTR_LOW_TAP_POSITION);
        double targetDeadband = AbstractTransformerXml.readTargetDeadband(context);
        PhaseTapChanger.RegulationMode regulationMode = (PhaseTapChanger.RegulationMode)XmlUtil.readOptionalEnum((XMLStreamReader)context.getReader(), (String)"regulationMode", PhaseTapChanger.RegulationMode.class);
        double regulationValue = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"regulationValue");
        adder.setLowTapPosition(lowTapPosition).setTargetDeadband(targetDeadband).setRegulationMode(regulationMode).setRegulationValue(regulationValue);
        XmlUtil.consumeOptionalIntAttribute((XMLStreamReader)context.getReader(), (String)ATTR_TAP_POSITION, arg_0 -> ((PhaseTapChangerAdder)adder).setTapPosition(arg_0));
        XmlUtil.consumeOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)ATTR_REGULATING, arg_0 -> ((PhaseTapChangerAdder)adder).setRegulating(arg_0));
        boolean[] hasTerminalRef = new boolean[1];
        XmlUtil.readUntilEndElement((String)name, (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "terminalRef": {
                    AbstractTransformerXml.readTerminalRef(context, hasTerminalRef, (id, side) -> {
                        adder.setRegulationTerminal(TerminalRefXml.resolve(id, side, terminal.getVoltageLevel().getNetwork()));
                        adder.add();
                    });
                    break;
                }
                case "step": {
                    PhaseTapChangerAdder.StepAdder stepAdder = adder.beginStep();
                    AbstractTransformerXml.readSteps(context, (r, x, g, b, rho) -> stepAdder.setR(r).setX(x).setG(g).setB(b).setRho(rho));
                    double alpha = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"alpha");
                    stepAdder.setAlpha(alpha).endStep();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    protected static void readPhaseTapChanger(TwoWindingsTransformer twt, NetworkXmlReaderContext context) throws XMLStreamException {
        AbstractTransformerXml.readPhaseTapChanger(PHASE_TAP_CHANGER, twt.newPhaseTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readPhaseTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkXmlReaderContext context) throws XMLStreamException {
        AbstractTransformerXml.readPhaseTapChanger(PHASE_TAP_CHANGER + leg, twl.newPhaseTapChanger(), twl.getTerminal(), context);
    }

    private static void readTerminalRef(NetworkXmlReaderContext context, boolean[] hasTerminalRef, BiConsumer<String, String> consumer) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
        String side = context.getReader().getAttributeValue(null, "side");
        context.getEndTasks().add(() -> consumer.accept(id, side));
        hasTerminalRef[0] = true;
    }

    private static void readSteps(NetworkXmlReaderContext context, StepConsumer consumer) {
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r");
        double x = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x");
        double g = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g");
        double b = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b");
        double rho = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"rho");
        consumer.accept(r, x, g, b, rho);
    }

    protected static void readRatedS(String name, NetworkXmlReaderContext context, DoubleConsumer consumer) {
        double ratedS = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)name);
        consumer.accept(ratedS);
    }

    protected static void writeRatedS(String name, double ratedS, NetworkXmlWriterContext context) {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> XmlUtil.writeOptionalDouble((String)name, (double)ratedS, (double)Double.NaN, (XMLStreamWriter)context.getWriter()));
    }

    private static interface StepConsumer {
        public void accept(double var1, double var3, double var5, double var7, double var9);
    }
}

