/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;

public final class AliasesXml {
    static final String ALIAS = "alias";

    public static void write(Identifiable<?> identifiable, String rootElementName, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersionIfNotDefault(!identifiable.getAliases().isEmpty(), rootElementName, ALIAS, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
        for (String alias : identifiable.getAliases()) {
            context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), ALIAS);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_4, context, () -> identifiable.getAliasType(alias).ifPresent(type -> {
                try {
                    context.getWriter().writeAttribute("type", (String)type);
                }
                catch (XMLStreamException e) {
                    throw new UncheckedXmlStreamException(e);
                }
            }));
            context.getWriter().writeCharacters(context.getAnonymizer().anonymizeString(alias));
            context.getWriter().writeEndElement();
        }
    }

    public static <T extends Identifiable> void read(T identifiable, NetworkXmlReaderContext context) throws XMLStreamException {
        AliasesXml.read(context).accept(identifiable);
    }

    public static <T extends Identifiable> void read(List<Consumer<T>> toApply, NetworkXmlReaderContext context) throws XMLStreamException {
        toApply.add(AliasesXml.read(context));
    }

    private static <T extends Identifiable> Consumer<T> read(NetworkXmlReaderContext context) throws XMLStreamException {
        if (!context.getReader().getLocalName().equals(ALIAS)) {
            throw new IllegalStateException();
        }
        String[] aliasType = new String[1];
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_4, context, () -> {
            aliasType[0] = context.getReader().getAttributeValue(null, "type");
        });
        String alias = context.getAnonymizer().deanonymizeString(context.getReader().getElementText());
        return identifiable -> identifiable.addAlias(alias, aliasType[0]);
    }

    private AliasesXml() {
    }
}

