/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.ReactiveLimitsXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class BatteryXml
extends AbstractSimpleIdentifiableXml<Battery, BatteryAdder, VoltageLevel> {
    static final BatteryXml INSTANCE = new BatteryXml();
    static final String ROOT_ELEMENT_NAME = "battery";

    BatteryXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Battery b) {
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Battery b, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)IidmXmlUtil.getAttributeName("p0", "targetP", context.getVersion(), IidmXmlVersion.V_1_8), (double)b.getTargetP(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)IidmXmlUtil.getAttributeName("q0", "targetQ", context.getVersion(), IidmXmlVersion.V_1_8), (double)b.getTargetQ(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"minP", (double)b.getMinP(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"maxP", (double)b.getMaxP(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(null, b.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, b.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(Battery b, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        ReactiveLimitsXml.INSTANCE.write((ReactiveLimitsHolder)b, context);
    }

    @Override
    protected BatteryAdder createAdder(VoltageLevel vl) {
        return vl.newBattery();
    }

    @Override
    protected Battery readRootElementAttributes(BatteryAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        double targetP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)IidmXmlUtil.getAttributeName("p0", "targetP", context.getVersion(), IidmXmlVersion.V_1_8));
        double targetQ = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)IidmXmlUtil.getAttributeName("q0", "targetQ", context.getVersion(), IidmXmlVersion.V_1_8));
        double minP = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"minP");
        double maxP = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"maxP");
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        Battery b = adder.setTargetP(targetP).setTargetQ(targetQ).setMinP(minP).setMaxP(maxP).add();
        ConnectableXmlUtil.readPQ(null, b.getTerminal(), context.getReader());
        return b;
    }

    @Override
    protected void readSubElements(Battery b, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "reactiveCapabilityCurve": 
                case "minMaxReactiveLimits": {
                    ReactiveLimitsXml.INSTANCE.read((ReactiveLimitsHolder)b, context);
                    break;
                }
                default: {
                    super.readSubElements(b, context);
                }
            }
        });
    }
}

