/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSwitchXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusBreakerViewSwitchXml
extends AbstractSwitchXml<VoltageLevel.BusBreakerView.SwitchAdder> {
    static final BusBreakerViewSwitchXml INSTANCE = new BusBreakerViewSwitchXml();
    private static final Logger LOGGER = LoggerFactory.getLogger(BusBreakerViewSwitchXml.class);

    @Override
    protected boolean isValid(Switch s, VoltageLevel vl) {
        VoltageLevel.BusBreakerView v = vl.getBusBreakerView();
        if (v.getBus1(s.getId()).getId().equals(v.getBus2(s.getId()).getId())) {
            LOGGER.warn("Discard switch with same bus at both ends. Id: {}", (Object)s.getId());
            return false;
        }
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Switch s, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        super.writeRootElementAttributes(s, vl, context);
        VoltageLevel.BusBreakerView v = vl.getBusBreakerView();
        Bus bus1 = v.getBus1(s.getId());
        Bus bus2 = v.getBus2(s.getId());
        context.getWriter().writeAttribute("bus1", context.getAnonymizer().anonymizeString(bus1.getId()));
        context.getWriter().writeAttribute("bus2", context.getAnonymizer().anonymizeString(bus2.getId()));
    }

    @Override
    protected VoltageLevel.BusBreakerView.SwitchAdder createAdder(VoltageLevel vl) {
        return vl.getBusBreakerView().newSwitch();
    }

    @Override
    protected Switch readRootElementAttributes(VoltageLevel.BusBreakerView.SwitchAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        boolean open = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"open");
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> {
            boolean fictitious = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)"fictitious", (boolean)false);
            adder.setFictitious(fictitious);
        });
        String bus1 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "bus1"));
        String bus2 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "bus2"));
        if (bus1.equals(bus2)) {
            LOGGER.warn("Discard switch with same bus at both ends. Id: {}", (Object)context.getReader().getAttributeValue(null, "id"));
            return null;
        }
        return adder.setOpen(open).setBus1(bus1).setBus2(bus2).add();
    }
}

