/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.xml.ExportOptions;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class BusFilter {
    private final Set<String> buses;
    private final ExportOptions options;

    public static BusFilter create(Network n, ExportOptions options) {
        HashSet<String> buses = null;
        if (options.isOnlyMainCc()) {
            buses = new HashSet<String>();
            BusFilter.addBusOfMainCC(buses, n, options);
            BusFilter.addBusOfOtherSideOfOpenBranches(buses, n, options);
            if (n.getThreeWindingsTransformerCount() != 0) {
                throw new IllegalStateException("TODO");
            }
        }
        return new BusFilter(buses, options);
    }

    static void addBusOfMainCC(Set<String> buses, Network n, ExportOptions options) {
        if (options.getTopologyLevel() == TopologyLevel.BUS_BRANCH) {
            for (Bus b : n.getBusView().getBuses()) {
                if (!b.isInMainConnectedComponent()) continue;
                buses.add(b.getId());
            }
        } else {
            for (Bus b : n.getBusBreakerView().getBuses()) {
                if (!b.isInMainConnectedComponent()) continue;
                buses.add(b.getId());
            }
        }
    }

    static void addBusOfOtherSideOfOpenBranches(Set<String> buses, Network n, ExportOptions options) {
        n.getBranchStream().forEach(branch -> {
            Terminal t1 = branch.getTerminal1();
            Terminal t2 = branch.getTerminal2();
            if (options.getTopologyLevel() == TopologyLevel.BUS_BRANCH) {
                Bus b1 = t1.getBusView().getConnectableBus();
                Bus b2 = t2.getBusView().getConnectableBus();
                if (b1 != null && b1.isInMainConnectedComponent() && b2 != null && !b2.isInMainConnectedComponent()) {
                    buses.add(b2.getId());
                } else if (b1 != null && !b1.isInMainConnectedComponent() && b2 != null && b2.isInMainConnectedComponent()) {
                    buses.add(b1.getId());
                }
            } else {
                Bus b1 = t1.getBusBreakerView().getConnectableBus();
                Bus b2 = t2.getBusBreakerView().getConnectableBus();
                if (b1.isInMainConnectedComponent() && !b2.isInMainConnectedComponent()) {
                    buses.add(b2.getId());
                } else if (!b1.isInMainConnectedComponent() && b2.isInMainConnectedComponent()) {
                    buses.add(b1.getId());
                }
            }
        });
    }

    BusFilter(Set<String> buses, ExportOptions options) {
        this.buses = buses;
        this.options = Objects.requireNonNull(options);
    }

    BusFilter(ExportOptions options) {
        this(null, options);
    }

    public boolean test(Bus b) {
        return this.buses == null || this.buses.contains(b.getId());
    }

    public boolean test(Connectable<?> connectable) {
        if (this.buses == null) {
            return true;
        }
        for (Terminal t : connectable.getTerminals()) {
            Bus b = this.options.getTopologyLevel() == TopologyLevel.BUS_BRANCH ? t.getBusView().getConnectableBus() : t.getBusBreakerView().getConnectableBus();
            if (b == null || this.buses.contains(b.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean test(TieLine tl) {
        Bus b;
        if (this.buses == null) {
            return true;
        }
        Bus bus = b = this.options.getTopologyLevel() == TopologyLevel.BUS_BRANCH ? tl.getDanglingLine1().getTerminal().getBusView().getConnectableBus() : tl.getDanglingLine1().getTerminal().getBusBreakerView().getConnectableBus();
        if (b != null && !this.buses.contains(b.getId())) {
            return false;
        }
        b = this.options.getTopologyLevel() == TopologyLevel.BUS_BRANCH ? tl.getDanglingLine2().getTerminal().getBusView().getConnectableBus() : tl.getDanglingLine2().getTerminal().getBusBreakerView().getConnectableBus();
        return b == null || this.buses.contains(b.getId());
    }
}

