/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class BusXml
extends AbstractSimpleIdentifiableXml<Bus, BusAdder, VoltageLevel> {
    static final BusXml INSTANCE = new BusXml();
    static final String ROOT_ELEMENT_NAME = "bus";

    BusXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Bus b) {
        return false;
    }

    @Override
    protected void writeRootElementAttributes(Bus b, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"v", (double)b.getV(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"angle", (double)b.getAngle(), (XMLStreamWriter)context.getWriter());
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_8, context, () -> {
            XmlUtil.writeOptionalDouble((String)"fictitiousP0", (double)b.getFictitiousP0(), (double)0.0, (XMLStreamWriter)context.getWriter());
            XmlUtil.writeOptionalDouble((String)"fictitiousQ0", (double)b.getFictitiousQ0(), (double)0.0, (XMLStreamWriter)context.getWriter());
        });
    }

    @Override
    protected void writeSubElements(Bus b, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
    }

    @Override
    protected BusAdder createAdder(VoltageLevel vl) {
        return vl.getBusBreakerView().newBus();
    }

    @Override
    protected Bus readRootElementAttributes(BusAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        double v = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"v");
        double angle = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"angle");
        Bus b = adder.add();
        b.setV(v);
        b.setAngle(angle);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_8, context, () -> {
            double p0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fictitiousP0");
            double q0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fictitiousQ0");
            if (!Double.isNaN(p0)) {
                b.setFictitiousP0(p0);
            }
            if (!Double.isNaN(q0)) {
                b.setFictitiousQ0(q0);
            }
        });
        return b;
    }

    @Override
    protected void readSubElements(Bus b, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> BusXml.super.readSubElements((Identifiable)b, context));
    }
}

