/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class BusbarSectionXml
extends AbstractSimpleIdentifiableXml<BusbarSection, BusbarSectionAdder, VoltageLevel> {
    static final BusbarSectionXml INSTANCE = new BusbarSectionXml();
    static final String ROOT_ELEMENT_NAME = "busbarSection";

    BusbarSectionXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(BusbarSection bs) {
        return false;
    }

    @Override
    protected void writeRootElementAttributes(BusbarSection bs, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeInt((String)"node", (int)bs.getTerminal().getNodeBreakerView().getNode(), (XMLStreamWriter)context.getWriter());
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_0, context, () -> {
            XmlUtil.writeDouble((String)"v", (double)bs.getV(), (XMLStreamWriter)context.getWriter());
            XmlUtil.writeDouble((String)"angle", (double)bs.getAngle(), (XMLStreamWriter)context.getWriter());
        });
    }

    @Override
    protected BusbarSectionAdder createAdder(VoltageLevel vl) {
        return vl.getNodeBreakerView().newBusbarSection();
    }

    @Override
    protected BusbarSection readRootElementAttributes(BusbarSectionAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        int node = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)"node");
        BusbarSection bbs = adder.setNode(node).add();
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_0, context, () -> {
            double v = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"v");
            double angle = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"angle");
            context.getEndTasks().add(() -> {
                Bus b = bbs.getTerminal().getBusView().getBus();
                if (b != null) {
                    b.setV(v).setAngle(angle);
                }
            });
        });
        return bbs;
    }

    @Override
    protected void readSubElements(BusbarSection bs, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> BusbarSectionXml.super.readSubElements((Identifiable)bs, context));
    }
}

