/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.xml.ExportOptions;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class ConnectableXmlUtil {
    private static final String BUS = "bus";
    private static final String CONNECTABLE_BUS = "connectableBus";
    private static final String NODE = "node";
    static final String ACTIVE_POWER_LIMITS = "activePowerLimits";
    static final String APPARENT_POWER_LIMITS = "apparentPowerLimits";
    static final String ACTIVE_POWER_LIMITS_1 = "activePowerLimits1";
    static final String ACTIVE_POWER_LIMITS_2 = "activePowerLimits2";
    static final String APPARENT_POWER_LIMITS_1 = "apparentPowerLimits1";
    static final String APPARENT_POWER_LIMITS_2 = "apparentPowerLimits2";
    static final String ACTIVE_POWER_LIMITS_3 = "activePowerLimits3";
    static final String APPARENT_POWER_LIMITS_3 = "apparentPowerLimits3";
    private static final String CURRENT_LIMITS = "currentLimits";

    private ConnectableXmlUtil() {
    }

    private static String indexToString(Integer index) {
        return index != null ? index.toString() : "";
    }

    public static boolean hasValidOperationalLimits(Branch<?> branch, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(IidmXmlVersion.V_1_5) >= 0) {
            return !branch.getOperationalLimits1().isEmpty() || !branch.getOperationalLimits2().isEmpty();
        }
        return branch.getCurrentLimits1().isPresent() || branch.getCurrentLimits2().isPresent();
    }

    public static boolean hasValidOperationalLimits(FlowsLimitsHolder limitsHolder, NetworkXmlWriterContext context) {
        if (context.getVersion().compareTo(IidmXmlVersion.V_1_5) >= 0) {
            return !limitsHolder.getOperationalLimits().isEmpty();
        }
        return limitsHolder.getCurrentLimits().isPresent();
    }

    public static void writeNodeOrBus(Integer index, Terminal t, NetworkXmlWriterContext context) throws XMLStreamException {
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)t.getVoltageLevel().getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        switch (topologyLevel) {
            case NODE_BREAKER: {
                ConnectableXmlUtil.writeNode(index, t, context);
                break;
            }
            case BUS_BREAKER: {
                ConnectableXmlUtil.writeBus(index, t.getBusBreakerView().getBus(), t.getBusBreakerView().getConnectableBus(), context);
                break;
            }
            case BUS_BRANCH: {
                ConnectableXmlUtil.writeBus(index, t.getBusView().getBus(), t.getBusView().getConnectableBus(), context);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TopologyLevel value: " + topologyLevel);
            }
        }
        if (index != null) {
            context.getWriter().writeAttribute("voltageLevelId" + index, context.getAnonymizer().anonymizeString(t.getVoltageLevel().getId()));
        }
    }

    private static void writeNode(Integer index, Terminal t, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute(NODE + ConnectableXmlUtil.indexToString(index), Integer.toString(t.getNodeBreakerView().getNode()));
    }

    private static void writeBus(Integer index, Bus bus, Bus connectableBus, NetworkXmlWriterContext context) throws XMLStreamException {
        if (bus != null) {
            context.getWriter().writeAttribute(BUS + ConnectableXmlUtil.indexToString(index), context.getAnonymizer().anonymizeString(bus.getId()));
        }
        if (connectableBus != null) {
            context.getWriter().writeAttribute(CONNECTABLE_BUS + ConnectableXmlUtil.indexToString(index), context.getAnonymizer().anonymizeString(connectableBus.getId()));
        }
    }

    public static void readNodeOrBus(InjectionAdder<?, ?> adder, NetworkXmlReaderContext context) {
        ConnectableXmlUtil.readNodeOrBus(adder, "", context);
    }

    public static void readNodeOrBus(InjectionAdder<?, ?> adder, String suffix, NetworkXmlReaderContext context) {
        String bus = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, BUS + suffix));
        String connectableBus = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, CONNECTABLE_BUS + suffix));
        Integer node = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)(NODE + suffix));
        if (bus != null) {
            adder.setBus(bus);
        }
        if (connectableBus != null) {
            adder.setConnectableBus(connectableBus);
        }
        if (node != null) {
            adder.setNode(node.intValue());
        }
    }

    public static void readNodeOrBus(BranchAdder<?, ?> adder, NetworkXmlReaderContext context) {
        String bus1 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "bus1"));
        String connectableBus1 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "connectableBus1"));
        Integer node1 = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)"node1");
        String voltageLevelId1 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "voltageLevelId1"));
        String bus2 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "bus2"));
        String connectableBus2 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "connectableBus2"));
        Integer node2 = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)"node2");
        String voltageLevelId2 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "voltageLevelId2"));
        if (bus1 != null) {
            adder.setBus1(bus1);
        }
        if (connectableBus1 != null) {
            adder.setConnectableBus1(connectableBus1);
        }
        if (node1 != null) {
            adder.setNode1(node1.intValue());
        }
        adder.setVoltageLevel1(voltageLevelId1);
        if (bus2 != null) {
            adder.setBus2(bus2);
        }
        if (connectableBus2 != null) {
            adder.setConnectableBus2(connectableBus2);
        }
        if (node2 != null) {
            adder.setNode2(node2.intValue());
        }
        adder.setVoltageLevel2(voltageLevelId2);
    }

    public static void readNodeOrBus(int index, ThreeWindingsTransformerAdder.LegAdder adder, NetworkXmlReaderContext context) {
        String bus = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, BUS + index));
        String connectableBus = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, CONNECTABLE_BUS + index));
        Integer node = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)(NODE + index));
        String voltageLevelId = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "voltageLevelId" + index));
        if (bus != null) {
            adder.setBus(bus);
        }
        if (connectableBus != null) {
            adder.setConnectableBus(connectableBus);
        }
        if (node != null) {
            adder.setNode(node.intValue());
        }
        adder.setVoltageLevel(voltageLevelId);
    }

    public static void writePQ(Integer index, Terminal t, XMLStreamWriter writer) throws XMLStreamException {
        XmlUtil.writeOptionalDouble((String)("p" + ConnectableXmlUtil.indexToString(index)), (double)t.getP(), (double)Double.NaN, (XMLStreamWriter)writer);
        XmlUtil.writeOptionalDouble((String)("q" + ConnectableXmlUtil.indexToString(index)), (double)t.getQ(), (double)Double.NaN, (XMLStreamWriter)writer);
    }

    public static void readPQ(Integer index, Terminal t, XMLStreamReader reader) {
        double p = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)("p" + ConnectableXmlUtil.indexToString(index)));
        double q = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)("q" + ConnectableXmlUtil.indexToString(index)));
        t.setP(p).setQ(q);
    }

    public static void readActivePowerLimits(Integer index, ActivePowerLimitsAdder activePowerLimitsAdder, XMLStreamReader reader) throws XMLStreamException {
        ConnectableXmlUtil.readLoadingLimits(index, ACTIVE_POWER_LIMITS, activePowerLimitsAdder, reader);
    }

    public static void readApparentPowerLimits(Integer index, ApparentPowerLimitsAdder apparentPowerLimitsAdder, XMLStreamReader reader) throws XMLStreamException {
        ConnectableXmlUtil.readLoadingLimits(index, APPARENT_POWER_LIMITS, apparentPowerLimitsAdder, reader);
    }

    public static void readCurrentLimits(Integer index, CurrentLimitsAdder currentLimitsAdder, XMLStreamReader reader) throws XMLStreamException {
        ConnectableXmlUtil.readLoadingLimits(index, CURRENT_LIMITS, currentLimitsAdder, reader);
    }

    private static <A extends LoadingLimitsAdder> void readLoadingLimits(Integer index, String type, A adder, XMLStreamReader reader) throws XMLStreamException {
        double permanentLimit = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"permanentLimit");
        adder.setPermanentLimit(permanentLimit);
        XmlUtil.readUntilEndElement((String)(type + ConnectableXmlUtil.indexToString(index)), (XMLStreamReader)reader, () -> {
            if ("temporaryLimit".equals(reader.getLocalName())) {
                String name = reader.getAttributeValue(null, "name");
                int acceptableDuration = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)reader, (String)"acceptableDuration", (int)Integer.MAX_VALUE);
                double value = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"value", (double)Double.MAX_VALUE);
                boolean fictitious = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)reader, (String)"fictitious", (boolean)false);
                adder.beginTemporaryLimit().setName(name).setAcceptableDuration(acceptableDuration).setValue(value).setFictitious(fictitious).endTemporaryLimit();
            }
        });
        adder.add();
    }

    static void writeActivePowerLimits(Integer index, ActivePowerLimits limits, XMLStreamWriter writer, IidmXmlVersion version, boolean valid, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeLoadingLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions, ACTIVE_POWER_LIMITS);
    }

    static void writeApparentPowerLimits(Integer index, ApparentPowerLimits limits, XMLStreamWriter writer, IidmXmlVersion version, boolean valid, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeLoadingLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions, APPARENT_POWER_LIMITS);
    }

    @Deprecated(since="3.2.0")
    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, IidmXmlVersion version) throws XMLStreamException {
        ConnectableXmlUtil.writeCurrentLimits(index, limits, writer, version, new ExportOptions());
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, IidmXmlVersion version, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeCurrentLimits(index, limits, writer, version, true, exportOptions);
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, IidmXmlVersion version, boolean valid, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeCurrentLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions);
    }

    @Deprecated(since="3.2.0")
    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, String nsUri, IidmXmlVersion version) throws XMLStreamException {
        ConnectableXmlUtil.writeCurrentLimits(index, limits, writer, nsUri, version, new ExportOptions());
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, String nsUri, IidmXmlVersion version, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeLoadingLimits(index, limits, writer, nsUri, version, true, exportOptions, CURRENT_LIMITS);
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, XMLStreamWriter writer, String nsUri, IidmXmlVersion version, boolean valid, ExportOptions exportOptions) throws XMLStreamException {
        ConnectableXmlUtil.writeLoadingLimits(index, limits, writer, nsUri, version, valid, exportOptions, CURRENT_LIMITS);
    }

    private static <L extends LoadingLimits> void writeLoadingLimits(Integer index, L limits, XMLStreamWriter writer, String nsUri, IidmXmlVersion version, boolean valid, ExportOptions exportOptions, String type) throws XMLStreamException {
        if (!Double.isNaN(limits.getPermanentLimit()) || !limits.getTemporaryLimits().isEmpty()) {
            if (limits.getTemporaryLimits().isEmpty()) {
                writer.writeEmptyElement(nsUri, type + ConnectableXmlUtil.indexToString(index));
            } else {
                writer.writeStartElement(nsUri, type + ConnectableXmlUtil.indexToString(index));
            }
            XmlUtil.writeDouble((String)"permanentLimit", (double)limits.getPermanentLimit(), (XMLStreamWriter)writer);
            for (LoadingLimits.TemporaryLimit tl : IidmXmlUtil.sortedTemporaryLimits(limits.getTemporaryLimits(), exportOptions)) {
                writer.writeEmptyElement(version.getNamespaceURI(valid), "temporaryLimit");
                writer.writeAttribute("name", tl.getName());
                XmlUtil.writeOptionalInt((String)"acceptableDuration", (int)tl.getAcceptableDuration(), (int)Integer.MAX_VALUE, (XMLStreamWriter)writer);
                XmlUtil.writeOptionalDouble((String)"value", (double)tl.getValue(), (double)Double.MAX_VALUE, (XMLStreamWriter)writer);
                XmlUtil.writeOptionalBoolean((String)"fictitious", (boolean)tl.isFictitious(), (boolean)false, (XMLStreamWriter)writer);
            }
            if (!limits.getTemporaryLimits().isEmpty()) {
                writer.writeEndElement();
            }
        }
    }
}

