/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.ReactiveLimitsXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Optional;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class DanglingLineXml
extends AbstractSimpleIdentifiableXml<DanglingLine, DanglingLineAdder, VoltageLevel> {
    private static final String GENERATION = "generation";
    private static final String GENERATION_MAX_P = "generationMaxP";
    private static final String GENERATION_MIN_P = "generationMinP";
    private static final String GENERATION_TARGET_P = "generationTargetP";
    private static final String GENERATION_TARGET_Q = "generationTargetQ";
    private static final String GENERATION_TARGET_V = "generationTargetV";
    static final DanglingLineXml INSTANCE = new DanglingLineXml();
    static final String ROOT_ELEMENT_NAME = "danglingLine";

    DanglingLineXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(DanglingLine dl) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    protected boolean hasSubElements(DanglingLine dl, NetworkXmlWriterContext context) {
        return DanglingLineXml.hasValidGeneration(dl, context) || ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)dl, context);
    }

    @Override
    protected void writeRootElementAttributes(DanglingLine dl, VoltageLevel parent, NetworkXmlWriterContext context) throws XMLStreamException {
        DanglingLineXml.writeRootElementAttributesInternal(dl, () -> ((DanglingLine)dl).getTerminal(), context);
    }

    static void writeRootElementAttributesInternal(DanglingLine dl, Supplier<Terminal> terminalGetter, NetworkXmlWriterContext context) throws XMLStreamException {
        DanglingLine.Generation generation = dl.getGeneration();
        double[] p0 = new double[1];
        double[] q0 = new double[1];
        p0[0] = dl.getP0();
        q0[0] = dl.getQ0();
        if (generation != null) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, GENERATION, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
            IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_2, context, () -> {
                if (!Double.isNaN(generation.getTargetP())) {
                    p0[0] = p0[0] - generation.getTargetP();
                }
                if (!Double.isNaN(generation.getTargetQ())) {
                    q0[0] = q0[0] - generation.getTargetQ();
                }
            });
        }
        XmlUtil.writeDouble((String)"p0", (double)p0[0], (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"q0", (double)q0[0], (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"r", (double)dl.getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x", (double)dl.getX(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"g", (double)dl.getG(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"b", (double)dl.getB(), (XMLStreamWriter)context.getWriter());
        if (generation != null) {
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
                XmlUtil.writeDouble((String)GENERATION_MIN_P, (double)generation.getMinP(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)GENERATION_MAX_P, (double)generation.getMaxP(), (XMLStreamWriter)context.getWriter());
                context.getWriter().writeAttribute("generationVoltageRegulationOn", Boolean.toString(generation.isVoltageRegulationOn()));
                XmlUtil.writeDouble((String)GENERATION_TARGET_P, (double)generation.getTargetP(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)GENERATION_TARGET_V, (double)generation.getTargetV(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)GENERATION_TARGET_Q, (double)generation.getTargetQ(), (XMLStreamWriter)context.getWriter());
            });
        }
        if (dl.getPairingKey() != null) {
            IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_10, context, () -> context.getWriter().writeAttribute("ucteXnodeCode", dl.getPairingKey()));
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> context.getWriter().writeAttribute("pairingKey", dl.getPairingKey()));
        }
        Terminal t = terminalGetter.get();
        ConnectableXmlUtil.writeNodeOrBus(null, t, context);
        ConnectableXmlUtil.writePQ(null, t, context.getWriter());
    }

    @Override
    protected DanglingLineAdder createAdder(VoltageLevel parent) {
        return parent.newDanglingLine();
    }

    static boolean hasValidGeneration(DanglingLine dl, NetworkXmlWriterContext context) {
        if (dl.getGeneration() != null) {
            return context.getVersion().compareTo(IidmXmlVersion.V_1_3) > 0;
        }
        return false;
    }

    @Override
    protected void writeSubElements(DanglingLine dl, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        Optional currentLimits;
        Optional apparentPowerLimits;
        Optional activePowerLimits;
        if (dl.getGeneration() != null) {
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> ReactiveLimitsXml.INSTANCE.write((ReactiveLimitsHolder)dl.getGeneration(), context));
        }
        if ((activePowerLimits = dl.getActivePowerLimits()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(null, (ActivePowerLimits)activePowerLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits = dl.getApparentPowerLimits()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(null, (ApparentPowerLimits)apparentPowerLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits = dl.getCurrentLimits()).isPresent()) {
            ConnectableXmlUtil.writeCurrentLimits(null, (CurrentLimits)currentLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
    }

    @Override
    protected DanglingLine readRootElementAttributes(DanglingLineAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        DanglingLineXml.readRootElementAttributesInternal(adder, context);
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_10, context, () -> {
            String pairingKey = context.getReader().getAttributeValue(null, "ucteXnodeCode");
            adder.setPairingKey(pairingKey);
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> {
            String pairingKey = context.getReader().getAttributeValue(null, "pairingKey");
            adder.setPairingKey(pairingKey);
        });
        DanglingLine dl = adder.add();
        ConnectableXmlUtil.readPQ(null, dl.getTerminal(), context.getReader());
        return dl;
    }

    public static void readRootElementAttributesInternal(DanglingLineAdder adder, NetworkXmlReaderContext context) {
        double p0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p0");
        double q0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q0");
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r");
        double x = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x");
        double g = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g");
        double b = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b");
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
            String voltageRegulationOnStr = context.getReader().getAttributeValue(null, "generationVoltageRegulationOn");
            if (voltageRegulationOnStr != null) {
                double minP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)GENERATION_MIN_P);
                double maxP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)GENERATION_MAX_P);
                boolean voltageRegulationOn = Boolean.parseBoolean(voltageRegulationOnStr);
                double targetP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)GENERATION_TARGET_P);
                double targetV = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)GENERATION_TARGET_V);
                double targetQ = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)GENERATION_TARGET_Q);
                adder.newGeneration().setMinP(minP).setMaxP(maxP).setVoltageRegulationOn(voltageRegulationOn).setTargetP(targetP).setTargetV(targetV).setTargetQ(targetQ).add();
            }
        });
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        adder.setP0(p0).setQ0(q0).setR(r).setX(x).setG(g).setB(b);
    }

    @Override
    protected void readSubElements(DanglingLine dl, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "activePowerLimits": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(null, dl.newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(null, dl.newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits": {
                    ConnectableXmlUtil.readCurrentLimits(null, dl.newCurrentLimits(), context.getReader());
                    break;
                }
                case "reactiveCapabilityCurve": 
                case "minMaxReactiveLimits": {
                    IidmXmlUtil.assertMinimumVersion("danglingLine.generation", "reactiveLimits", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
                    ReactiveLimitsXml.INSTANCE.read((ReactiveLimitsHolder)dl.getGeneration(), context);
                    break;
                }
                default: {
                    super.readSubElements(dl, context);
                }
            }
        });
    }
}

