/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.ReactiveLimitsXml;
import com.powsybl.iidm.xml.TerminalRefXml;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class GeneratorXml
extends AbstractSimpleIdentifiableXml<Generator, GeneratorAdder, VoltageLevel> {
    static final GeneratorXml INSTANCE = new GeneratorXml();
    static final String ROOT_ELEMENT_NAME = "generator";

    GeneratorXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Generator g) {
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Generator g, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute("energySource", g.getEnergySource().name());
        XmlUtil.writeDouble((String)"minP", (double)g.getMinP(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"maxP", (double)g.getMaxP(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"ratedS", (double)g.getRatedS(), (XMLStreamWriter)context.getWriter());
        context.getWriter().writeAttribute("voltageRegulatorOn", Boolean.toString(g.isVoltageRegulatorOn()));
        XmlUtil.writeDouble((String)"targetP", (double)g.getTargetP(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"targetV", (double)g.getTargetV(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"targetQ", (double)g.getTargetQ(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(null, g.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, g.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(Generator g, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        if (g != g.getRegulatingTerminal().getConnectable()) {
            TerminalRefXml.writeTerminalRef(g.getRegulatingTerminal(), context, "regulatingTerminal");
        }
        ReactiveLimitsXml.INSTANCE.write((ReactiveLimitsHolder)g, context);
    }

    @Override
    protected GeneratorAdder createAdder(VoltageLevel vl) {
        return vl.newGenerator();
    }

    @Override
    protected Generator readRootElementAttributes(GeneratorAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        String energySourceStr = context.getReader().getAttributeValue(null, "energySource");
        EnergySource energySource = energySourceStr != null ? EnergySource.valueOf((String)energySourceStr) : null;
        double minP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"minP");
        double maxP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"maxP");
        double ratedS = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedS");
        String voltageRegulatorOn = context.getReader().getAttributeValue(null, "voltageRegulatorOn");
        double targetP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetP");
        double targetV = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetV");
        double targetQ = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetQ");
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        adder.setEnergySource(energySource).setMinP(minP).setMaxP(maxP).setRatedS(ratedS).setTargetP(targetP).setTargetV(targetV).setTargetQ(targetQ).setVoltageRegulatorOn(Boolean.parseBoolean(voltageRegulatorOn));
        Generator g = adder.add();
        ConnectableXmlUtil.readPQ(null, g.getTerminal(), context.getReader());
        return g;
    }

    @Override
    protected void readSubElements(Generator g, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "regulatingTerminal": {
                    String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
                    String side = context.getReader().getAttributeValue(null, "side");
                    context.getEndTasks().add(() -> g.setRegulatingTerminal(TerminalRefXml.resolve(id, side, g.getNetwork())));
                    break;
                }
                case "reactiveCapabilityCurve": 
                case "minMaxReactiveLimits": {
                    ReactiveLimitsXml.INSTANCE.read((ReactiveLimitsHolder)g, context);
                    break;
                }
                default: {
                    super.readSubElements(g, context);
                }
            }
        });
    }
}

