/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class HvdcLineXml
extends AbstractSimpleIdentifiableXml<HvdcLine, HvdcLineAdder, Network> {
    static final HvdcLineXml INSTANCE = new HvdcLineXml();
    static final String ROOT_ELEMENT_NAME = "hvdcLine";

    HvdcLineXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(HvdcLine identifiable) {
        return false;
    }

    @Override
    protected void writeRootElementAttributes(HvdcLine l, Network parent, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"r", (double)l.getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"nominalV", (double)l.getNominalV(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalEnum((String)"convertersMode", (Enum)l.getConvertersMode(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"activePowerSetpoint", (double)l.getActivePowerSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"maxP", (double)l.getMaxP(), (XMLStreamWriter)context.getWriter());
        context.getWriter().writeAttribute("converterStation1", context.getAnonymizer().anonymizeString(l.getConverterStation1().getId()));
        context.getWriter().writeAttribute("converterStation2", context.getAnonymizer().anonymizeString(l.getConverterStation2().getId()));
    }

    @Override
    protected HvdcLineAdder createAdder(Network n) {
        return n.newHvdcLine();
    }

    @Override
    protected HvdcLine readRootElementAttributes(HvdcLineAdder adder, Network network, NetworkXmlReaderContext context) {
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r");
        double nominalV = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"nominalV");
        HvdcLine.ConvertersMode convertersMode = (HvdcLine.ConvertersMode)XmlUtil.readOptionalEnum((XMLStreamReader)context.getReader(), (String)"convertersMode", HvdcLine.ConvertersMode.class);
        double activePowerSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"activePowerSetpoint");
        double maxP = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"maxP");
        String converterStation1 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "converterStation1"));
        String converterStation2 = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "converterStation2"));
        return adder.setR(r).setNominalV(nominalV).setConvertersMode(convertersMode).setActivePowerSetpoint(activePowerSetpoint).setMaxP(maxP).setConverterStationId1(converterStation1).setConverterStationId2(converterStation2).add();
    }

    @Override
    protected void readSubElements(HvdcLine l, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> HvdcLineXml.super.readSubElements((Identifiable)l, context));
    }
}

