/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.PowsyblException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IidmXmlVersion {
    V_1_0("itesla_project.eu", List.of(Integer.valueOf(1), Integer.valueOf(0))),
    V_1_1("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(1))),
    V_1_2("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(2))),
    V_1_3("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(3))),
    V_1_4("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(4))),
    V_1_5("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(5))),
    V_1_6("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(6))),
    V_1_7("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(7))),
    V_1_8("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(8))),
    V_1_9("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(9))),
    V_1_10("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(10))),
    V_1_11("powsybl.org", List.of(Integer.valueOf(1), Integer.valueOf(11)));

    private final String domain;
    private final List<Integer> versionArray;

    private IidmXmlVersion(String domain, List<Integer> versionArray) {
        this.domain = domain;
        this.versionArray = versionArray;
    }

    public String toString(String separator) {
        return this.versionArray.stream().map(Object::toString).collect(Collectors.joining(separator));
    }

    public boolean supportEquipmentValidationLevel() {
        return this.compareTo(V_1_7) >= 0;
    }

    public String getNamespaceURI() {
        return "http://www." + this.domain + "/schema/iidm/" + this.toString("_");
    }

    public String getNamespaceURI(boolean valid) {
        if (valid) {
            return this.getNamespaceURI();
        }
        if (this.compareTo(V_1_7) < 0) {
            throw new PowsyblException("Network in Equipment mode not supported for XIIDM version < 1.7");
        }
        return "http://www." + this.domain + "/schema/iidm/equipment/" + this.toString("_");
    }

    public String getXsd() {
        return "iidm_V" + this.toString("_") + ".xsd";
    }

    public String getXsd(boolean valid) {
        if (valid) {
            return this.getXsd();
        }
        if (this.compareTo(V_1_7) < 0) {
            throw new PowsyblException("Invalid network not supported for XIIDM version < 1.7");
        }
        return "iidm_equipment_V" + this.toString("_") + ".xsd";
    }

    public static IidmXmlVersion fromNamespaceURI(String namespaceURI) {
        String version = namespaceURI.substring(namespaceURI.lastIndexOf(47) + 1);
        IidmXmlVersion v = IidmXmlVersion.of(version, "_");
        String namespaceUriV = v.getNamespaceURI();
        if (!namespaceURI.equals(namespaceUriV)) {
            if (v.compareTo(V_1_7) >= 0 && namespaceURI.equals(v.getNamespaceURI(false))) {
                return v;
            }
            throw new PowsyblException("Namespace " + namespaceURI + " is not supported. The namespace for IIDM XML version " + v.toString(".") + " is: " + namespaceUriV + ".");
        }
        return v;
    }

    public static IidmXmlVersion of(String version, String separator) {
        return Stream.of(IidmXmlVersion.values()).filter(v -> version.equals(v.toString(separator))).findFirst().orElseThrow(() -> new PowsyblException("Version " + version + " is not supported."));
    }
}

