/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class LccConverterStationXml
extends AbstractSimpleIdentifiableXml<LccConverterStation, LccConverterStationAdder, VoltageLevel> {
    static final LccConverterStationXml INSTANCE = new LccConverterStationXml();
    static final String ROOT_ELEMENT_NAME = "lccConverterStation";

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(LccConverterStation cs) {
        return false;
    }

    @Override
    protected void writeRootElementAttributes(LccConverterStation cs, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeFloat((String)"lossFactor", (float)cs.getLossFactor(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeFloat((String)"powerFactor", (float)cs.getPowerFactor(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(null, cs.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, cs.getTerminal(), context.getWriter());
    }

    @Override
    protected LccConverterStationAdder createAdder(VoltageLevel vl) {
        return vl.newLccConverterStation();
    }

    @Override
    protected LccConverterStation readRootElementAttributes(LccConverterStationAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        float lossFactor = XmlUtil.readFloatAttribute((XMLStreamReader)context.getReader(), (String)"lossFactor");
        float powerFactor = XmlUtil.readOptionalFloatAttribute((XMLStreamReader)context.getReader(), (String)"powerFactor");
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        LccConverterStation cs = ((LccConverterStationAdder)adder.setLossFactor(lossFactor)).setPowerFactor(powerFactor).add();
        ConnectableXmlUtil.readPQ(null, cs.getTerminal(), context.getReader());
        return cs;
    }

    @Override
    protected void readSubElements(LccConverterStation cs, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> LccConverterStationXml.super.readSubElements((Identifiable)cs, context));
    }
}

