/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class LineXml
extends AbstractSimpleIdentifiableXml<Line, LineAdder, Network> {
    static final LineXml INSTANCE = new LineXml();
    static final String ROOT_ELEMENT_NAME = "line";

    LineXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Line l) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    protected boolean hasSubElements(Line l, NetworkXmlWriterContext context) {
        return ConnectableXmlUtil.hasValidOperationalLimits(l, context);
    }

    @Override
    protected void writeRootElementAttributes(Line l, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"r", (double)l.getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x", (double)l.getX(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"g1", (double)l.getG1(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"b1", (double)l.getB1(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"g2", (double)l.getG2(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"b2", (double)l.getB2(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(1, l.getTerminal1(), context);
        ConnectableXmlUtil.writeNodeOrBus(2, l.getTerminal2(), context);
        if (context.getOptions().isWithBranchSV()) {
            ConnectableXmlUtil.writePQ(1, l.getTerminal1(), context.getWriter());
            ConnectableXmlUtil.writePQ(2, l.getTerminal2(), context.getWriter());
        }
    }

    @Override
    protected void writeSubElements(Line l, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        Optional currentLimits2;
        Optional apparentPowerLimits2;
        Optional activePowerLimits2;
        Optional currentLimits1;
        Optional apparentPowerLimits1;
        Optional activePowerLimits1 = l.getActivePowerLimits1();
        if (activePowerLimits1.isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits1 = l.getApparentPowerLimits1()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits1 = l.getCurrentLimits1()).isPresent()) {
            ConnectableXmlUtil.writeCurrentLimits((Integer)1, (CurrentLimits)currentLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
        if ((activePowerLimits2 = l.getActivePowerLimits2()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits2 = l.getApparentPowerLimits2()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits2 = l.getCurrentLimits2()).isPresent()) {
            ConnectableXmlUtil.writeCurrentLimits((Integer)2, (CurrentLimits)currentLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
    }

    @Override
    protected LineAdder createAdder(Network n) {
        return n.newLine();
    }

    @Override
    protected Line readRootElementAttributes(LineAdder adder, Network network, NetworkXmlReaderContext context) {
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r");
        double x = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x");
        double g1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g1");
        double b1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b1");
        double g2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g2");
        double b2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b2");
        adder.setR(r).setX(x).setG1(g1).setB1(b1).setG2(g2).setB2(b2);
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        Line l = adder.add();
        ConnectableXmlUtil.readPQ(1, l.getTerminal1(), context.getReader());
        ConnectableXmlUtil.readPQ(2, l.getTerminal2(), context.getReader());
        return l;
    }

    @Override
    protected void readSubElements(Line l, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "activePowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(1, l.newActivePowerLimits1(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(1, l.newApparentPowerLimits1(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    ConnectableXmlUtil.readCurrentLimits(1, l.newCurrentLimits1(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(2, l.newActivePowerLimits2(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(2, l.newApparentPowerLimits2(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    ConnectableXmlUtil.readCurrentLimits(2, l.newCurrentLimits2(), context.getReader());
                    break;
                }
                default: {
                    super.readSubElements(l, context);
                }
            }
        });
    }
}

