/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ExponentialLoadModel;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadModel;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.ZipLoadModel;
import com.powsybl.iidm.xml.AbstractComplexIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class LoadXml
extends AbstractComplexIdentifiableXml<Load, LoadAdder, VoltageLevel> {
    static final LoadXml INSTANCE = new LoadXml();
    static final String ROOT_ELEMENT_NAME = "load";
    public static final String MODEL = "model";
    private static final String EXPONENTIAL_MODEL = "exponentialModel";
    private static final String ZIP_MODEL = "zipModel";

    LoadXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Load l) {
        return l.getModel().isPresent();
    }

    @Override
    protected boolean hasSubElements(Load l, NetworkXmlWriterContext context) {
        return this.hasSubElements(l) && context.getVersion().compareTo(IidmXmlVersion.V_1_10) >= 0;
    }

    @Override
    protected void writeRootElementAttributes(Load l, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute("loadType", l.getLoadType().name());
        XmlUtil.writeDouble((String)"p0", (double)l.getP0(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"q0", (double)l.getQ0(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(null, l.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, l.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(Load load, VoltageLevel parent, NetworkXmlWriterContext context) throws XMLStreamException {
        load.getModel().ifPresent(model -> {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, MODEL, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_10, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_10, context, () -> this.writeModel((LoadModel)model, context));
        });
    }

    private void writeModel(LoadModel model, NetworkXmlWriterContext context) throws XMLStreamException {
        switch (model.getType()) {
            case EXPONENTIAL: {
                ExponentialLoadModel expModel = (ExponentialLoadModel)model;
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), EXPONENTIAL_MODEL);
                XmlUtil.writeDouble((String)"np", (double)expModel.getNp(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"nq", (double)expModel.getNq(), (XMLStreamWriter)context.getWriter());
                break;
            }
            case ZIP: {
                ZipLoadModel zipModel = (ZipLoadModel)model;
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), ZIP_MODEL);
                XmlUtil.writeDouble((String)"c0p", (double)zipModel.getC0p(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"c1p", (double)zipModel.getC1p(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"c2p", (double)zipModel.getC2p(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"c0q", (double)zipModel.getC0q(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"c1q", (double)zipModel.getC1q(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)"c2q", (double)zipModel.getC2q(), (XMLStreamWriter)context.getWriter());
                break;
            }
            default: {
                throw new PowsyblException("Unexpected load model type: " + model.getType());
            }
        }
    }

    @Override
    protected LoadAdder createAdder(VoltageLevel vl) {
        return vl.newLoad();
    }

    @Override
    protected void readRootElementAttributes(LoadAdder adder, List<Consumer<Load>> toApply, NetworkXmlReaderContext context) {
        String loadTypeStr = context.getReader().getAttributeValue(null, "loadType");
        LoadType loadType = loadTypeStr == null ? LoadType.UNDEFINED : LoadType.valueOf((String)loadTypeStr);
        double p0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p0");
        double q0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q0");
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        adder.setLoadType(loadType).setP0(p0).setQ0(q0);
        double p = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p");
        double q = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q");
        toApply.add(l -> l.getTerminal().setP(p).setQ(q));
    }

    @Override
    protected void readSubElements(String id, LoadAdder adder, List<Consumer<Load>> toApply, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "exponentialModel": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, EXPONENTIAL_MODEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_10, context);
                    double np = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"np");
                    double nq = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"nq");
                    adder.newExponentialModel().setNp(np).setNq(nq).add();
                    break;
                }
                case "zipModel": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, EXPONENTIAL_MODEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_10, context);
                    double c0p = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c0p");
                    double c1p = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c1p");
                    double c2p = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c2p");
                    double c0q = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c0q");
                    double c1q = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c1q");
                    double c2q = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"c2q");
                    adder.newZipModel().setC0p(c0p).setC1p(c1p).setC2p(c2p).setC0q(c0q).setC1q(c1q).setC2q(c2q).add();
                    break;
                }
                default: {
                    super.readSubElements(id, toApply, context);
                }
            }
        });
    }
}

