/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.exceptions.UncheckedSaxException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractOptions;
import com.powsybl.iidm.xml.AliasesXml;
import com.powsybl.iidm.xml.BusFilter;
import com.powsybl.iidm.xml.ExportOptions;
import com.powsybl.iidm.xml.HvdcLineXml;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.ImportOptions;
import com.powsybl.iidm.xml.LineXml;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.PropertiesXml;
import com.powsybl.iidm.xml.SubstationXml;
import com.powsybl.iidm.xml.TieLineXml;
import com.powsybl.iidm.xml.VoltageAngleLimitXml;
import com.powsybl.iidm.xml.VoltageLevelXml;
import com.powsybl.iidm.xml.anonymizer.Anonymizer;
import com.powsybl.iidm.xml.anonymizer.SimpleAnonymizer;
import com.powsybl.iidm.xml.extensions.AbstractVersionableNetworkExtensionXmlSerializer;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class NetworkXml {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkXml.class);
    private static final String EXTENSION_CATEGORY_NAME = "network";
    static final String NETWORK_ROOT_ELEMENT_NAME = "network";
    private static final String EXTENSION_ELEMENT_NAME = "extension";
    private static final String CASE_DATE = "caseDate";
    private static final String FORECAST_DISTANCE = "forecastDistance";
    private static final String SOURCE_FORMAT = "sourceFormat";
    private static final String ID = "id";
    private static final String MINIMUM_VALIDATION_LEVEL = "minimumValidationLevel";
    private static final String VOLTAGE_ANGLE_LIMIT_ELEMENT_NAME = "voltageAngleLimit";
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLInputFactory::newInstance);
    private static final Supplier<XMLOutputFactory> XML_OUTPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLOutputFactory::newFactory);
    private static final Supplier<ExtensionProviders<ExtensionXmlSerializer>> EXTENSIONS_SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionXmlSerializer.class, (String)"network"));

    private NetworkXml() {
    }

    private static void validate(Source xml, List<Source> additionalSchemas) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            int length = IidmXmlVersion.values().length + (int)Arrays.stream(IidmXmlVersion.values()).filter(IidmXmlVersion::supportEquipmentValidationLevel).count();
            Source[] sources = new Source[additionalSchemas.size() + length];
            int i = 0;
            int j = 0;
            for (IidmXmlVersion version : IidmXmlVersion.values()) {
                sources[i] = new StreamSource(NetworkXml.class.getResourceAsStream("/xsd/" + version.getXsd()));
                if (version.supportEquipmentValidationLevel()) {
                    sources[j + IidmXmlVersion.values().length] = new StreamSource(NetworkXml.class.getResourceAsStream("/xsd/" + version.getXsd(false)));
                    ++j;
                }
                ++i;
            }
            for (int k = 0; k < additionalSchemas.size(); ++k) {
                sources[k + length] = additionalSchemas.get(k);
            }
            Schema schema = factory.newSchema(sources);
            Validator validator = schema.newValidator();
            validator.validate(xml);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (SAXException e) {
            throw new UncheckedSaxException(e);
        }
    }

    public static void validate(InputStream is) {
        ArrayList<Source> additionalSchemas = new ArrayList<Source>();
        for (ExtensionXmlSerializer e : ((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).getProviders()) {
            e.getXsdAsStreamList().forEach(xsd -> additionalSchemas.add(new StreamSource((InputStream)xsd)));
        }
        NetworkXml.validate(new StreamSource(is), additionalSchemas);
    }

    public static void validate(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            NetworkXml.validate(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void throwExceptionIfOption(AbstractOptions<?> options, String message) {
        if (options.isThrowExceptionIfExtensionNotFound()) {
            throw new PowsyblException(message);
        }
        LOGGER.warn(message);
    }

    private static void writeExtensionNamespaces(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        HashSet<String> extensionUris = new HashSet<String>();
        HashSet<String> extensionPrefixes = new HashSet<String>();
        IidmXmlVersion networkVersion = NetworkXml.getNetworkVersion(context.getOptions());
        Set serializers = n.getIdentifiables().stream().flatMap(identifiable -> identifiable.getExtensions().stream().filter(e -> NetworkXml.canTheExtensionBeWritten(NetworkXml.getExtensionXmlSerializer(context.getOptions(), e), networkVersion, context.getOptions())).map(extension -> NetworkXml.getExtensionXmlSerializer(context.getOptions(), extension))).collect(Collectors.toCollection(LinkedHashSet::new));
        for (ExtensionXmlSerializer extensionXmlSerializer : serializers) {
            String namespaceUri = NetworkXml.getNamespaceUri(extensionXmlSerializer, context.getOptions(), networkVersion);
            if (extensionUris.contains(namespaceUri)) {
                throw new PowsyblException("Extension namespace URI collision");
            }
            extensionUris.add(namespaceUri);
            if (extensionPrefixes.contains(extensionXmlSerializer.getNamespacePrefix())) {
                throw new PowsyblException("Extension namespace prefix collision");
            }
            extensionPrefixes.add(extensionXmlSerializer.getNamespacePrefix());
            context.getWriter().setPrefix(extensionXmlSerializer.getNamespacePrefix(), namespaceUri);
            context.getWriter().writeNamespace(extensionXmlSerializer.getNamespacePrefix(), namespaceUri);
        }
    }

    private static void writeExtension(Extension<? extends Identifiable<?>> extension, NetworkXmlWriterContext context) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        ExtensionXmlSerializer extensionXmlSerializer = NetworkXml.getExtensionXmlSerializer(context.getOptions(), extension);
        if (extensionXmlSerializer == null) {
            throw new IllegalStateException("Extension XML Serializer of " + extension.getName() + " should not be null");
        }
        String namespaceUri = NetworkXml.getNamespaceUri(extensionXmlSerializer, context.getOptions(), context.getVersion());
        if (extensionXmlSerializer.hasSubElements()) {
            writer.writeStartElement(namespaceUri, extension.getName());
        } else {
            writer.writeEmptyElement(namespaceUri, extension.getName());
        }
        context.getExtensionVersion(extension.getName()).ifPresent(arg_0 -> ((ExtensionXmlSerializer)extensionXmlSerializer).checkExtensionVersionSupported(arg_0));
        extensionXmlSerializer.write(extension, (XmlWriterContext)context);
        if (extensionXmlSerializer.hasSubElements()) {
            writer.writeEndElement();
        }
    }

    private static ExtensionXmlSerializer getExtensionXmlSerializer(ExportOptions options, Extension<? extends Identifiable<?>> extension) {
        if (options.withExtension(extension.getName())) {
            ExtensionXmlSerializer extensionXmlSerializer;
            ExtensionXmlSerializer extensionXmlSerializer2 = extensionXmlSerializer = options.isThrowExceptionIfExtensionNotFound() ? (ExtensionXmlSerializer)((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).findProviderOrThrowException(extension.getName()) : (ExtensionXmlSerializer)((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).findProvider(extension.getName());
            if (extensionXmlSerializer == null) {
                String message = "XmlSerializer for " + extension.getName() + " not found";
                NetworkXml.throwExceptionIfOption(options, message);
            } else if (!extensionXmlSerializer.isSerializable(extension)) {
                return null;
            }
            return extensionXmlSerializer;
        }
        return null;
    }

    private static IidmXmlVersion getNetworkVersion(ExportOptions options) {
        return options.getVersion() == null ? IidmXmlConstants.CURRENT_IIDM_XML_VERSION : IidmXmlVersion.of(options.getVersion(), ".");
    }

    private static String getNamespaceUri(ExtensionXmlSerializer extensionXmlSerializer, ExportOptions options, IidmXmlVersion networkVersion) {
        if (extensionXmlSerializer instanceof AbstractVersionableNetworkExtensionXmlSerializer) {
            AbstractVersionableNetworkExtensionXmlSerializer networkExtensionXmlSerializer = (AbstractVersionableNetworkExtensionXmlSerializer)extensionXmlSerializer;
            return options.getExtensionVersion(networkExtensionXmlSerializer.getExtensionName()).map(extensionVersion -> {
                networkExtensionXmlSerializer.checkWritingCompatibility((String)extensionVersion, networkVersion);
                return networkExtensionXmlSerializer.getNamespaceUri((String)extensionVersion);
            }).orElseGet(() -> networkExtensionXmlSerializer.getNamespaceUri(networkExtensionXmlSerializer.getVersion(networkVersion)));
        }
        return options.getExtensionVersion(extensionXmlSerializer.getExtensionName()).map(arg_0 -> ((ExtensionXmlSerializer)extensionXmlSerializer).getNamespaceUri(arg_0)).orElseGet(() -> ((ExtensionXmlSerializer)extensionXmlSerializer).getNamespaceUri());
    }

    private static void writeVoltageAngleLimits(Network n, NetworkXmlWriterContext context) {
        if (!n.getVoltageAngleLimitsStream().findAny().isEmpty()) {
            for (VoltageAngleLimit voltageAngleLimit : n.getVoltageAngleLimits()) {
                VoltageAngleLimitXml.write(voltageAngleLimit, context);
            }
        }
    }

    private static void writeExtensions(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Identifiable identifiable : IidmXmlUtil.sorted(n.getIdentifiables(), context.getOptions())) {
            Collection extensions;
            if (!context.isExportedEquipment(identifiable) || !NetworkXml.isElementWrittenInsideNetwork(identifiable, n, context) || (extensions = (Collection)identifiable.getExtensions().stream().filter(e -> NetworkXml.canTheExtensionBeWritten(NetworkXml.getExtensionXmlSerializer(context.getOptions(), e), context.getVersion(), context.getOptions())).collect(Collectors.toList())).isEmpty()) continue;
            context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(n.getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS), EXTENSION_ELEMENT_NAME);
            context.getWriter().writeAttribute(ID, context.getAnonymizer().anonymizeString(identifiable.getId()));
            for (Extension<? extends Identifiable<?>> extension : IidmXmlUtil.sortedExtensions(extensions, context.getOptions())) {
                NetworkXml.writeExtension(extension, context);
            }
            context.getWriter().writeEndElement();
        }
    }

    private static boolean canTheExtensionBeWritten(ExtensionXmlSerializer extensionXmlSerializer, IidmXmlVersion version, ExportOptions options) {
        if (extensionXmlSerializer == null) {
            return false;
        }
        boolean versionExist = true;
        if (extensionXmlSerializer instanceof AbstractVersionableNetworkExtensionXmlSerializer) {
            AbstractVersionableNetworkExtensionXmlSerializer networkExtensionXmlSerializer = (AbstractVersionableNetworkExtensionXmlSerializer)extensionXmlSerializer;
            versionExist = networkExtensionXmlSerializer.versionExists(version);
        }
        if (!versionExist) {
            String message = String.format("Version %s does not support %s extension", new Object[]{version, extensionXmlSerializer.getExtensionName()});
            NetworkXml.throwExceptionIfOption(options, message);
        }
        return versionExist;
    }

    private static void writeMainAttributes(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        writer.writeAttribute(ID, context.getAnonymizer().anonymizeString(n.getId()));
        writer.writeAttribute(CASE_DATE, n.getCaseDate().toString());
        writer.writeAttribute(FORECAST_DISTANCE, Integer.toString(n.getForecastDistance()));
        writer.writeAttribute(SOURCE_FORMAT, n.getSourceFormat());
    }

    private static void writeRootElement(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        ExportOptions options = context.getOptions();
        IidmXmlVersion version = options.getVersion() == null ? IidmXmlConstants.CURRENT_IIDM_XML_VERSION : IidmXmlVersion.of(options.getVersion(), ".");
        String namespaceUri = version.getNamespaceURI(n.getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS);
        IidmXmlUtil.assertMinimumVersionIfNotDefault(n.getValidationLevel() != ValidationLevel.STEADY_STATE_HYPOTHESIS, "network", MINIMUM_VALIDATION_LEVEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_7, version);
        context.getWriter().setPrefix("iidm", namespaceUri);
        context.getWriter().writeStartElement(namespaceUri, "network");
        if (n.getParentNetwork() == n) {
            context.getWriter().writeNamespace("iidm", namespaceUri);
            if (!options.withNoExtension()) {
                NetworkXml.writeExtensionNamespaces(n, context);
            }
        }
        NetworkXml.writeMainAttributes(n, context);
    }

    private static void writeBaseNetwork(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_7, context, () -> context.getWriter().writeAttribute(MINIMUM_VALIDATION_LEVEL, n.getValidationLevel().toString()));
        AliasesXml.write(n, "network", context);
        PropertiesXml.write(n, context);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> NetworkXml.writeSubnetworks(n, context));
        NetworkXml.writeVoltageLevels(n, context);
        NetworkXml.writeSubstations(n, context);
        NetworkXml.writeLines(n, context);
        NetworkXml.writeTieLines(n, context);
        NetworkXml.writeHvdcLines(n, context);
    }

    private static void writeSubnetworks(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Network subnetwork : IidmXmlUtil.sorted(n.getSubnetworks(), context.getOptions())) {
            IidmXmlUtil.assertMinimumVersion("network", "voltageLevel", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_11, context);
            NetworkXml.write(subnetwork, context);
        }
    }

    private static void writeVoltageLevels(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        for (VoltageLevel voltageLevel : IidmXmlUtil.sorted(n.getVoltageLevels(), context.getOptions())) {
            if (!NetworkXml.isElementWrittenInsideNetwork(voltageLevel, n, context) || !voltageLevel.getSubstation().isEmpty()) continue;
            IidmXmlUtil.assertMinimumVersion("network", "voltageLevel", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_6, context);
            VoltageLevelXml.INSTANCE.write(voltageLevel, n, context);
        }
    }

    private static void writeSubstations(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Substation s : IidmXmlUtil.sorted(n.getSubstations(), context.getOptions())) {
            if (!NetworkXml.isElementWrittenInsideNetwork(s, n, context)) continue;
            SubstationXml.INSTANCE.write(s, n, context);
        }
    }

    private static void writeLines(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        BusFilter filter = context.getFilter();
        for (Line l : IidmXmlUtil.sorted(n.getLines(), context.getOptions())) {
            if (!NetworkXml.isElementWrittenInsideNetwork(l, n, context) || !filter.test((Connectable<?>)l)) continue;
            LineXml.INSTANCE.write(l, n, context);
        }
    }

    private static void writeTieLines(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        BusFilter filter = context.getFilter();
        for (TieLine l : IidmXmlUtil.sorted(n.getTieLines(), context.getOptions())) {
            if (!NetworkXml.isElementWrittenInsideNetwork(l, n, context) || !filter.test(l)) continue;
            TieLineXml.INSTANCE.write(l, n, context);
        }
    }

    private static void writeHvdcLines(Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        BusFilter filter = context.getFilter();
        for (HvdcLine l : IidmXmlUtil.sorted(n.getHvdcLines(), context.getOptions())) {
            if (!NetworkXml.isElementWrittenInsideNetwork(l, n, context) || !filter.test((Connectable<?>)l.getConverterStation1()) || !filter.test((Connectable<?>)l.getConverterStation2())) continue;
            HvdcLineXml.INSTANCE.write(l, n, context);
        }
    }

    private static void write(Network network, NetworkXmlWriterContext context) throws XMLStreamException {
        context.addExportedEquipment((Identifiable<?>)network);
        NetworkXml.writeRootElement(network, context);
        NetworkXml.writeBaseNetwork(network, context);
        NetworkXml.writeVoltageAngleLimits(network, context);
        NetworkXml.writeExtensions(network, context);
        context.getWriter().writeEndElement();
    }

    public static Anonymizer write(Network n, ExportOptions options, OutputStream os) {
        try {
            XMLStreamWriter writer = XmlUtil.initializeWriter((boolean)options.isIndent(), (String)"    ", (OutputStream)os, (Charset)options.getCharset());
            NetworkXmlWriterContext context = NetworkXml.createContext(n, options, writer);
            NetworkXml.write(n, context);
            context.getWriter().writeEndDocument();
            context.getWriter().close();
            return context.getAnonymizer();
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static boolean isElementWrittenInsideNetwork(Identifiable<?> element, Network n, NetworkXmlWriterContext context) {
        if (!NetworkXml.supportSubnetworksExport(context)) {
            return true;
        }
        if (n.getId().equals(element.getId())) {
            return true;
        }
        return element.getParentNetwork() == n && element.getType() != IdentifiableType.NETWORK;
    }

    private static boolean supportSubnetworksExport(NetworkXmlWriterContext context) {
        return context.getVersion().compareTo(IidmXmlVersion.V_1_11) >= 0;
    }

    private static NetworkXmlWriterContext createContext(Network n, ExportOptions options, XMLStreamWriter writer) {
        BusFilter filter = BusFilter.create(n, options);
        SimpleAnonymizer anonymizer = options.isAnonymized() ? new SimpleAnonymizer() : null;
        IidmXmlVersion version = options.getVersion() == null ? IidmXmlConstants.CURRENT_IIDM_XML_VERSION : IidmXmlVersion.of(options.getVersion(), ".");
        return new NetworkXmlWriterContext(anonymizer, writer, options, filter, version, n.getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS);
    }

    public static Anonymizer write(Network n, OutputStream os) {
        return NetworkXml.write(n, new ExportOptions(), os);
    }

    public static Anonymizer write(Network n, ExportOptions options, Path xmlFile) {
        Anonymizer anonymizer;
        BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(xmlFile, new OpenOption[0]));
        try {
            anonymizer = NetworkXml.write(n, options, os);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)os).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((OutputStream)os).close();
        return anonymizer;
    }

    public static Anonymizer write(Network n, Path xmlFile) {
        return NetworkXml.write(n, new ExportOptions(), xmlFile);
    }

    public static Anonymizer write(Network network, ExportOptions options, DataSource dataSource, String dataSourceExt) throws IOException {
        try (OutputStream osb = dataSource.newOutputStream("", dataSourceExt, false);){
            Anonymizer anonymizer;
            try (BufferedOutputStream bosb = new BufferedOutputStream(osb);){
                Anonymizer anonymizer2 = NetworkXml.write(network, options, bosb);
                if (options.isAnonymized()) {
                    try (BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(dataSource.newOutputStream("_mapping", "csv", false), StandardCharsets.UTF_8));){
                        anonymizer2.write(writer2);
                    }
                }
                anonymizer = anonymizer2;
            }
            return anonymizer;
        }
    }

    public static Anonymizer writeAndValidate(Network n, Path xmlFile) {
        return NetworkXml.writeAndValidate(n, new ExportOptions(), xmlFile);
    }

    public static Anonymizer writeAndValidate(Network n, ExportOptions options, Path xmlFile) {
        Anonymizer anonymizer = NetworkXml.write(n, options, xmlFile);
        NetworkXml.validate(xmlFile);
        return anonymizer;
    }

    public static Network read(InputStream is) {
        return NetworkXml.read(is, new ImportOptions(), null);
    }

    public static Network read(InputStream is, ImportOptions config, Anonymizer anonymizer) {
        return NetworkXml.read(is, config, anonymizer, NetworkFactory.findDefault());
    }

    public static Network read(InputStream is, ImportOptions config, Anonymizer anonymizer, NetworkFactory networkFactory) {
        try {
            XMLStreamReader reader = ((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()).createXMLStreamReader(is);
            int state = reader.next();
            while (state == 5) {
                state = reader.next();
            }
            IidmXmlVersion version = IidmXmlVersion.fromNamespaceURI(reader.getNamespaceURI());
            NetworkXmlReaderContext context = new NetworkXmlReaderContext(anonymizer, reader, config, version);
            Network network = NetworkXml.initNetwork(networkFactory, context, reader, null);
            if (!config.withNoExtension()) {
                context.buildExtensionNamespaceUriList(((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).getProviders().stream());
            }
            TreeSet<String> extensionNamesNotFound = new TreeSet<String>();
            ArrayDeque<Network> networks = new ArrayDeque<Network>(2);
            networks.push(network);
            XmlUtil.readUntilEndElement((String)"network", (XMLStreamReader)reader, () -> NetworkXml.readElements(networks, networkFactory, reader, context, extensionNamesNotFound));
            NetworkXml.checkExtensionsNotFound(context, extensionNamesNotFound);
            context.getEndTasks().forEach(Runnable::run);
            reader.close();
            XmlUtil.gcXmlInputFactory((XMLInputFactory)((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()));
            return network;
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static void readElements(Deque<Network> networks, NetworkFactory networkFactory, XMLStreamReader reader, NetworkXmlReaderContext context, Set<String> extensionNamesNotFound) throws XMLStreamException {
        String localName;
        switch (localName = reader.getLocalName()) {
            case "alias": {
                NetworkXml.checkSupportedAndReadAlias(networks.peek(), context);
                break;
            }
            case "property": {
                PropertiesXml.read((Identifiable)networks.peek(), context);
                break;
            }
            case "network": {
                NetworkXml.checkSupportedAndReadSubnetwork(networks, networkFactory, reader, context, extensionNamesNotFound);
                break;
            }
            case "voltageLevel": {
                NetworkXml.checkSupportedAndReadVoltageLevel(context, networks);
                break;
            }
            case "substation": {
                SubstationXml.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "line": {
                LineXml.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "tieLine": {
                TieLineXml.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "hvdcLine": {
                HvdcLineXml.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "voltageAngleLimit": {
                VoltageAngleLimitXml.read(networks.peek(), context);
                break;
            }
            case "extension": {
                NetworkXml.findExtendableAndReadExtension(networks.peek(), reader, context, extensionNamesNotFound);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void checkSupportedAndReadAlias(Network network, NetworkXmlReaderContext context) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersion("network", "alias", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
        AliasesXml.read(network, context);
    }

    private static void checkSupportedAndReadSubnetwork(Deque<Network> networks, NetworkFactory networkFactory, XMLStreamReader reader, NetworkXmlReaderContext context, Set<String> extensionNamesNotFound) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersion("network", "network", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_11, context);
        if (networks.size() > 1) {
            throw new PowsyblException("Only one level of subnetworks is currently supported.");
        }
        Network subnetwork = NetworkXml.initNetwork(networkFactory, context, reader, networks.peek());
        networks.push(subnetwork);
        XmlUtil.readUntilEndElement((String)"network", (XMLStreamReader)reader, () -> NetworkXml.readElements(networks, networkFactory, reader, context, extensionNamesNotFound));
        networks.pop();
    }

    private static void checkSupportedAndReadVoltageLevel(NetworkXmlReaderContext context, Deque<Network> networks) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersion("network", "voltageLevel", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_6, context);
        VoltageLevelXml.INSTANCE.read((Container)networks.peek(), context);
    }

    private static void findExtendableAndReadExtension(Network network, XMLStreamReader reader, NetworkXmlReaderContext context, Set<String> extensionNamesNotFound) throws XMLStreamException {
        String id2 = context.getAnonymizer().deanonymizeString(reader.getAttributeValue(null, ID));
        Identifiable identifiable = network.getIdentifiable(id2);
        if (identifiable == null) {
            throw new PowsyblException("Identifiable " + id2 + " not found");
        }
        NetworkXml.readExtensions(identifiable, context, extensionNamesNotFound);
    }

    private static Network initNetwork(NetworkFactory networkFactory, NetworkXmlReaderContext context, XMLStreamReader reader, Network rootNetwork) {
        String id = context.getAnonymizer().deanonymizeString(reader.getAttributeValue(null, ID));
        DateTime date = DateTime.parse((String)reader.getAttributeValue(null, CASE_DATE));
        int forecastDistance = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)reader, (String)FORECAST_DISTANCE, (int)0);
        String sourceFormat = reader.getAttributeValue(null, SOURCE_FORMAT);
        Network network = rootNetwork == null ? networkFactory.createNetwork(id, sourceFormat) : rootNetwork.createSubnetwork(id, id, sourceFormat);
        network.setCaseDate(date);
        network.setForecastDistance(forecastDistance);
        ValidationLevel[] minValidationLevel = new ValidationLevel[]{ValidationLevel.STEADY_STATE_HYPOTHESIS};
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_7, context, () -> {
            minValidationLevel[0] = ValidationLevel.valueOf((String)reader.getAttributeValue(null, MINIMUM_VALIDATION_LEVEL));
        });
        IidmXmlUtil.assertMinimumVersionIfNotDefault(minValidationLevel[0] != ValidationLevel.STEADY_STATE_HYPOTHESIS, "network", MINIMUM_VALIDATION_LEVEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_7, context);
        network.setMinimumAcceptableValidationLevel(minValidationLevel[0]);
        return network;
    }

    private static void checkExtensionsNotFound(NetworkXmlReaderContext context, Set<String> extensionNamesNotFound) {
        if (!extensionNamesNotFound.isEmpty()) {
            NetworkXml.throwExceptionIfOption(context.getOptions(), "Extensions " + extensionNamesNotFound + " not found !");
        }
    }

    public static Network read(Path xmlFile) {
        return NetworkXml.read(xmlFile, new ImportOptions());
    }

    public static Network read(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, ImportOptions options, String dataSourceExt) throws IOException {
        Network network;
        Objects.requireNonNull(dataSource);
        SimpleAnonymizer anonymizer = null;
        if (dataSource.exists("_mapping", "csv")) {
            anonymizer = new SimpleAnonymizer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(dataSource.newInputStream("_mapping", "csv"), StandardCharsets.UTF_8));){
                anonymizer.read(reader);
            }
        }
        try (InputStream isb = dataSource.newInputStream(null, dataSourceExt);){
            network = NetworkXml.read(isb, options, anonymizer, networkFactory);
        }
        return network;
    }

    public static Network read(Path xmlFile, ImportOptions options) {
        Network network;
        block8: {
            InputStream is = Files.newInputStream(xmlFile, new OpenOption[0]);
            try {
                network = NetworkXml.read(is, options, null);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return network;
    }

    public static Network validateAndRead(Path xmlFile, ImportOptions options) {
        NetworkXml.validate(xmlFile);
        return NetworkXml.read(xmlFile, options);
    }

    public static Network validateAndRead(Path xmlFile) {
        return NetworkXml.validateAndRead(xmlFile, new ImportOptions());
    }

    private static void readExtensions(Identifiable identifiable, NetworkXmlReaderContext context, Set<String> extensionNamesNotFound) throws XMLStreamException {
        XmlUtil.readUntilEndElementWithDepth((String)EXTENSION_ELEMENT_NAME, (XMLStreamReader)context.getReader(), elementDepth -> {
            if (elementDepth == 0) {
                String extensionName = context.getReader().getLocalName();
                if (!context.getOptions().withExtension(extensionName)) {
                    return;
                }
                ExtensionXmlSerializer extensionXmlSerializer = (ExtensionXmlSerializer)((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).findProvider(extensionName);
                if (extensionXmlSerializer != null) {
                    Extension extension = extensionXmlSerializer.read((Extendable)identifiable, (XmlReaderContext)context);
                    identifiable.addExtension(extensionXmlSerializer.getExtensionClass(), extension);
                } else {
                    extensionNamesNotFound.add(extensionName);
                }
            }
        });
    }

    public static void update(Network network, InputStream is) {
        try {
            XMLStreamReader reader = ((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()).createXMLStreamReader(is);
            reader.next();
            VoltageLevel[] vl = new VoltageLevel[1];
            XmlUtil.readUntilEndElement((String)"network", (XMLStreamReader)reader, () -> {
                switch (reader.getLocalName()) {
                    case "voltageLevel": {
                        NetworkXml.updateVoltageLevel(reader, network, vl);
                        break;
                    }
                    case "bus": {
                        NetworkXml.updateBus(reader, vl);
                        break;
                    }
                    case "generator": 
                    case "battery": 
                    case "load": 
                    case "shunt": 
                    case "danglingLine": 
                    case "lccConverterStation": 
                    case "vscConverterStation": {
                        NetworkXml.updateInjection(reader, network);
                        break;
                    }
                    case "line": 
                    case "twoWindingsTransformer": {
                        NetworkXml.updateBranch(reader, network);
                        break;
                    }
                    case "hvdcLine": 
                    case "network": {
                        break;
                    }
                    case "threeWindingsTransformer": {
                        throw new IllegalStateException();
                    }
                    default: {
                        throw new IllegalStateException("Unexpected element: " + reader.getLocalName());
                    }
                }
            });
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    public static void update(Network network, Path xmlFile) {
        try (InputStream is = Files.newInputStream(xmlFile, new OpenOption[0]);){
            NetworkXml.update(network, is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void updateVoltageLevel(XMLStreamReader reader, Network network, VoltageLevel[] vl) {
        String id = reader.getAttributeValue(null, ID);
        vl[0] = network.getVoltageLevel(id);
        if (vl[0] == null) {
            throw new PowsyblException("Voltage level '" + id + "' not found");
        }
    }

    private static void updateBus(XMLStreamReader reader, VoltageLevel[] vl) {
        String id = reader.getAttributeValue(null, ID);
        double v = XmlUtil.readDoubleAttribute((XMLStreamReader)reader, (String)"v");
        double angle = XmlUtil.readDoubleAttribute((XMLStreamReader)reader, (String)"angle");
        Bus b = vl[0].getBusBreakerView().getBus(id);
        if (b == null) {
            b = vl[0].getBusView().getBus(id);
        }
        b.setV(v > 0.0 ? v : Double.NaN).setAngle(angle);
    }

    private static void updateInjection(XMLStreamReader reader, Network network) {
        String id = reader.getAttributeValue(null, ID);
        double p = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"p");
        double q = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"q");
        Injection inj = (Injection)network.getIdentifiable(id);
        inj.getTerminal().setP(p).setQ(q);
    }

    private static void updateBranch(XMLStreamReader reader, Network network) {
        String id = reader.getAttributeValue(null, ID);
        double p1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"p1");
        double q1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"q1");
        double p2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"p2");
        double q2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"q2");
        Branch branch = (Branch)network.getIdentifiable(id);
        branch.getTerminal1().setP(p1).setQ(q1);
        branch.getTerminal2().setP(p2).setQ(q2);
    }

    public static byte[] gzip(Network network) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(bos);){
            NetworkXml.write(network, gzos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }

    public static Network gunzip(byte[] networkXmlGz) {
        Network network;
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(networkXmlGz));
        try {
            network = NetworkXml.read(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)is).close();
        return network;
    }

    public static Network copy(Network network) {
        return NetworkXml.copy(network, NetworkFactory.findDefault());
    }

    public static Network copy(Network network, NetworkFactory networkFactory) {
        return NetworkXml.copy(network, networkFactory, ForkJoinPool.commonPool());
    }

    public static Network copy(Network network, NetworkFactory networkFactory, ExecutorService executor) {
        Network network2;
        Objects.requireNonNull(network);
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(executor);
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(pos);
        try {
            executor.execute(() -> {
                try {
                    NetworkXml.write(network, pos);
                }
                catch (Exception t) {
                    LOGGER.error(t.toString(), (Throwable)t);
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
            });
            network2 = NetworkXml.read(is, new ImportOptions(), null, networkFactory);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)is).close();
        return network2;
    }
}

