/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.iidm.xml.AbstractNetworkXmlContext;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.ImportOptions;
import com.powsybl.iidm.xml.anonymizer.Anonymizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamReader;

public class NetworkXmlReaderContext
extends AbstractNetworkXmlContext<ImportOptions>
implements XmlReaderContext {
    private final XMLStreamReader reader;
    private final List<Runnable> endTasks = new ArrayList<Runnable>();
    private final ImportOptions options;
    private final Set<String> extensionsNamespaceUri = new HashSet<String>();

    public NetworkXmlReaderContext(Anonymizer anonymizer, XMLStreamReader reader) {
        this(anonymizer, reader, new ImportOptions(), IidmXmlConstants.CURRENT_IIDM_XML_VERSION);
    }

    public NetworkXmlReaderContext(Anonymizer anonymizer, XMLStreamReader reader, ImportOptions options, IidmXmlVersion version) {
        super(anonymizer, version);
        this.reader = Objects.requireNonNull(reader);
        this.options = Objects.requireNonNull(options);
    }

    public XMLStreamReader getReader() {
        return this.reader;
    }

    public List<Runnable> getEndTasks() {
        return this.endTasks;
    }

    @Override
    public ImportOptions getOptions() {
        return this.options;
    }

    public void buildExtensionNamespaceUriList(Stream<ExtensionXmlSerializer> providers) {
        providers.filter(e -> this.reader.getNamespaceURI(e.getNamespacePrefix()) != null).forEach(e -> this.extensionsNamespaceUri.add(this.reader.getNamespaceURI(e.getNamespacePrefix())));
    }

    public boolean containsExtensionNamespaceUri(String extensionNamespaceUri) {
        return this.extensionsNamespaceUri.contains(extensionNamespaceUri);
    }

    public Optional<String> getExtensionVersion(ExtensionXmlSerializer<?, ?> extensionXmlSerializer) {
        return extensionXmlSerializer.getVersions().stream().filter(v -> this.extensionsNamespaceUri.stream().anyMatch(uri -> extensionXmlSerializer.getNamespaceUri(v).equals(uri))).findFirst();
    }
}

