/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.xml.AbstractNetworkXmlContext;
import com.powsybl.iidm.xml.BusFilter;
import com.powsybl.iidm.xml.ExportOptions;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.anonymizer.Anonymizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamWriter;

public class NetworkXmlWriterContext
extends AbstractNetworkXmlContext<ExportOptions>
implements XmlWriterContext {
    private final XMLStreamWriter writer;
    private final ExportOptions options;
    private final BusFilter filter;
    private final boolean valid;
    private final Set<Identifiable> exportedEquipments;

    NetworkXmlWriterContext(Anonymizer anonymizer, XMLStreamWriter writer, ExportOptions options, BusFilter filter, IidmXmlVersion version, boolean valid) {
        super(anonymizer, version);
        this.writer = writer;
        this.options = options;
        this.filter = filter;
        this.valid = valid;
        this.exportedEquipments = new HashSet<Identifiable>();
    }

    NetworkXmlWriterContext(Anonymizer anonymizer, XMLStreamWriter writer, ExportOptions options, BusFilter filter, IidmXmlVersion version) {
        this(anonymizer, writer, options, filter, version, true);
    }

    NetworkXmlWriterContext(Anonymizer anonymizer, XMLStreamWriter writer, ExportOptions options, BusFilter filter) {
        this(anonymizer, writer, options, filter, IidmXmlConstants.CURRENT_IIDM_XML_VERSION);
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    @Override
    public ExportOptions getOptions() {
        return this.options;
    }

    public BusFilter getFilter() {
        return this.filter;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Deprecated(since="3.8.1")
    public void setExtensionsWriter(XMLStreamWriter extensionsWriter) {
    }

    public Set<Identifiable> getExportedEquipments() {
        return Collections.unmodifiableSet(this.exportedEquipments);
    }

    public void addExportedEquipment(Identifiable<?> equipment) {
        this.exportedEquipments.add(equipment);
    }

    public boolean isExportedEquipment(Identifiable<?> equipment) {
        return this.exportedEquipments.contains(equipment);
    }

    public Optional<String> getExtensionVersion(String extensionName) {
        return this.options.getExtensionVersion(extensionName);
    }
}

