/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSwitchXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeBreakerViewSwitchXml
extends AbstractSwitchXml<VoltageLevel.NodeBreakerView.SwitchAdder> {
    static final NodeBreakerViewSwitchXml INSTANCE = new NodeBreakerViewSwitchXml();
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeBreakerViewSwitchXml.class);

    @Override
    protected boolean isValid(Switch s, VoltageLevel vl) {
        VoltageLevel.NodeBreakerView v = vl.getNodeBreakerView();
        if (v.getNode1(s.getId()) == v.getNode2(s.getId())) {
            LOGGER.warn("Discard switch with same node at both ends. Id: {}", (Object)s.getId());
            return false;
        }
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Switch s, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        super.writeRootElementAttributes(s, vl, context);
        VoltageLevel.NodeBreakerView v = vl.getNodeBreakerView();
        context.getWriter().writeAttribute("node1", Integer.toString(v.getNode1(s.getId())));
        context.getWriter().writeAttribute("node2", Integer.toString(v.getNode2(s.getId())));
    }

    @Override
    protected VoltageLevel.NodeBreakerView.SwitchAdder createAdder(VoltageLevel vl) {
        return vl.getNodeBreakerView().newSwitch();
    }

    @Override
    protected Switch readRootElementAttributes(VoltageLevel.NodeBreakerView.SwitchAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        boolean open = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"open");
        SwitchKind kind = SwitchKind.valueOf((String)context.getReader().getAttributeValue(null, "kind"));
        boolean retained = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"retained");
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> {
            boolean fictitious = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)"fictitious", (boolean)false);
            adder.setFictitious(fictitious);
        });
        int node1 = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)"node1");
        int node2 = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)"node2");
        if (node1 == node2) {
            LOGGER.warn("Discard switch with same node at both ends. Id: {}", (Object)context.getReader().getAttributeValue(null, "id"));
            return null;
        }
        return adder.setKind(kind).setRetained(retained).setOpen(open).setNode1(node1).setNode2(node2).add();
    }
}

