/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;

public final class PropertiesXml {
    static final String PROPERTY = "property";
    static final String NAME = "name";
    static final String VALUE = "value";

    public static void write(Identifiable<?> identifiable, NetworkXmlWriterContext context) throws XMLStreamException {
        if (identifiable.hasProperty()) {
            for (String name : IidmXmlUtil.sortedNames(identifiable.getPropertyNames(), context.getOptions())) {
                String value = identifiable.getProperty(name);
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(identifiable.getNetwork().getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS), PROPERTY);
                context.getWriter().writeAttribute(NAME, name);
                context.getWriter().writeAttribute(VALUE, value);
            }
        }
    }

    public static void read(Identifiable identifiable, NetworkXmlReaderContext context) {
        PropertiesXml.read(context).accept(identifiable);
    }

    public static <T extends Identifiable> void read(List<Consumer<T>> toApply, NetworkXmlReaderContext context) {
        toApply.add(PropertiesXml.read(context));
    }

    private static <T extends Identifiable> Consumer<T> read(NetworkXmlReaderContext context) {
        if (!context.getReader().getLocalName().equals(PROPERTY)) {
            throw new IllegalStateException();
        }
        String name = context.getReader().getAttributeValue(null, NAME);
        String value = context.getReader().getAttributeValue(null, VALUE);
        return identifiable -> identifiable.setProperty(name, value);
    }

    private PropertiesXml() {
    }
}

