/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveCapabilityCurveAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReactiveLimitsXml {
    static final ReactiveLimitsXml INSTANCE = new ReactiveLimitsXml();
    private static final String ELEM_REACTIVE_CAPABILITY_CURVE = "reactiveCapabilityCurve";
    private static final String ELEM_MIN_MAX_REACTIVE_LIMITS = "minMaxReactiveLimits";
    private static final String ATTR_MIN_Q = "minQ";
    private static final String ATTR_MAX_Q = "maxQ";

    public void write(ReactiveLimitsHolder holder, NetworkXmlWriterContext context) throws XMLStreamException {
        switch (holder.getReactiveLimits().getKind()) {
            case CURVE: {
                ReactiveCapabilityCurve curve = (ReactiveCapabilityCurve)holder.getReactiveLimits(ReactiveCapabilityCurve.class);
                context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), ELEM_REACTIVE_CAPABILITY_CURVE);
                for (ReactiveCapabilityCurve.Point point : curve.getPoints()) {
                    context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), "point");
                    XmlUtil.writeDouble((String)"p", (double)point.getP(), (XMLStreamWriter)context.getWriter());
                    XmlUtil.writeDouble((String)ATTR_MIN_Q, (double)point.getMinQ(), (XMLStreamWriter)context.getWriter());
                    XmlUtil.writeDouble((String)ATTR_MAX_Q, (double)point.getMaxQ(), (XMLStreamWriter)context.getWriter());
                }
                context.getWriter().writeEndElement();
                break;
            }
            case MIN_MAX: {
                MinMaxReactiveLimits limits = (MinMaxReactiveLimits)holder.getReactiveLimits(MinMaxReactiveLimits.class);
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), ELEM_MIN_MAX_REACTIVE_LIMITS);
                XmlUtil.writeDouble((String)ATTR_MIN_Q, (double)limits.getMinQ(), (XMLStreamWriter)context.getWriter());
                XmlUtil.writeDouble((String)ATTR_MAX_Q, (double)limits.getMaxQ(), (XMLStreamWriter)context.getWriter());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void read(ReactiveLimitsHolder holder, NetworkXmlReaderContext context) throws XMLStreamException {
        switch (context.getReader().getLocalName()) {
            case "reactiveCapabilityCurve": {
                ReactiveCapabilityCurveAdder curveAdder = holder.newReactiveCapabilityCurve();
                XmlUtil.readUntilEndElement((String)ELEM_REACTIVE_CAPABILITY_CURVE, (XMLStreamReader)context.getReader(), () -> {
                    if (context.getReader().getLocalName().equals("point")) {
                        double p = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p");
                        double minQ = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)ATTR_MIN_Q);
                        double maxQ = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)ATTR_MAX_Q);
                        curveAdder.beginPoint().setP(p).setMinQ(minQ).setMaxQ(maxQ).endPoint();
                    }
                });
                curveAdder.add();
                break;
            }
            case "minMaxReactiveLimits": {
                double min = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)ATTR_MIN_Q);
                double max = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)ATTR_MAX_Q);
                holder.newMinMaxReactiveLimits().setMinQ(min).setMaxQ(max).add();
                break;
            }
        }
    }
}

