/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModel;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractComplexIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShuntXml
extends AbstractComplexIdentifiableXml<ShuntCompensator, ShuntCompensatorAdder, VoltageLevel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuntXml.class);
    static final ShuntXml INSTANCE = new ShuntXml();
    static final String ROOT_ELEMENT_NAME = "shunt";
    private static final String B_PER_SECTION = "bPerSection";
    private static final String MAXIMUM_SECTION_COUNT = "maximumSectionCount";
    private static final String REGULATING_TERMINAL = "regulatingTerminal";
    private static final String SHUNT_LINEAR_MODEL = "shuntLinearModel";
    private static final String SHUNT_NON_LINEAR_MODEL = "shuntNonLinearModel";

    ShuntXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(ShuntCompensator sc) {
        return sc != sc.getRegulatingTerminal().getConnectable();
    }

    @Override
    protected boolean hasSubElements(ShuntCompensator sc, NetworkXmlWriterContext context) {
        return this.hasSubElements(sc) || context.getVersion().compareTo(IidmXmlVersion.V_1_3) >= 0;
    }

    @Override
    protected void writeRootElementAttributes(ShuntCompensator sc, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        if (ShuntCompensatorModelType.NON_LINEAR == sc.getModelType()) {
            IidmXmlUtil.assertMinimumVersion(this.getRootElementName(), SHUNT_NON_LINEAR_MODEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
        }
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_2, context, () -> {
            double bPerSection;
            ShuntCompensatorModel model = sc.getModel();
            if (model instanceof ShuntCompensatorLinearModel) {
                ShuntCompensatorLinearModel shuntCompensatorLinearModel = (ShuntCompensatorLinearModel)model;
                v0 = shuntCompensatorLinearModel.getBPerSection();
            } else {
                v0 = bPerSection = sc.getB();
            }
            if (bPerSection == 0.0) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("bPerSection of {} is 0. It is set as {} since XIIDM version < 1.5 ({})", new Object[]{sc.getId(), Double.MIN_NORMAL, context.getVersion().toString(".")});
                }
                bPerSection = Double.MIN_NORMAL;
            }
            XmlUtil.writeDouble((String)B_PER_SECTION, (double)bPerSection, (XMLStreamWriter)context.getWriter());
            int maximumSectionCount = model instanceof ShuntCompensatorLinearModel ? sc.getMaximumSectionCount() : 1;
            context.getWriter().writeAttribute(MAXIMUM_SECTION_COUNT, Integer.toString(maximumSectionCount));
            int currentSectionCount = model instanceof ShuntCompensatorLinearModel ? sc.getSectionCount() : 1;
            context.getWriter().writeAttribute("currentSectionCount", Integer.toString(currentSectionCount));
        });
        if (sc.findSectionCount().isPresent()) {
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> context.getWriter().writeAttribute("sectionCount", Integer.toString(sc.getSectionCount())));
        }
        IidmXmlUtil.writeBooleanAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "voltageRegulatorOn", sc.isVoltageRegulatorOn(), false, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_2, context);
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "targetV", sc.getTargetV(), IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_2, context);
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "targetDeadband", sc.getTargetDeadband(), IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_2, context);
        ConnectableXmlUtil.writeNodeOrBus(null, sc.getTerminal(), context);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_9, context, () -> XmlUtil.writeOptionalDouble((String)"p", (double)sc.getTerminal().getP(), (double)Double.NaN, (XMLStreamWriter)context.getWriter()));
        XmlUtil.writeOptionalDouble((String)"q", (double)sc.getTerminal().getQ(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
    }

    @Override
    protected void writeSubElements(ShuntCompensator sc, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> ShuntXml.writeModel(sc, context));
        if (sc != sc.getRegulatingTerminal().getConnectable()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_2, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> TerminalRefXml.writeTerminalRef(sc.getRegulatingTerminal(), context, REGULATING_TERMINAL));
        }
    }

    @Override
    protected ShuntCompensatorAdder createAdder(VoltageLevel parent) {
        return parent.newShuntCompensator();
    }

    private static void writeModel(ShuntCompensator sc, NetworkXmlWriterContext context) throws XMLStreamException {
        if (sc.getModelType() == ShuntCompensatorModelType.LINEAR) {
            context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), SHUNT_LINEAR_MODEL);
            double bPerSection = ((ShuntCompensatorLinearModel)sc.getModel(ShuntCompensatorLinearModel.class)).getBPerSection();
            if (bPerSection == 0.0 && context.getVersion().compareTo(IidmXmlVersion.V_1_4) <= 0) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("bPerSection of {} is 0. It is set as {} since XIIDM version < 1.5 ({})", new Object[]{sc.getId(), Double.MIN_NORMAL, context.getVersion().toString(".")});
                }
                bPerSection = Double.MIN_NORMAL;
            }
            XmlUtil.writeDouble((String)B_PER_SECTION, (double)bPerSection, (XMLStreamWriter)context.getWriter());
            XmlUtil.writeDouble((String)"gPerSection", (double)((ShuntCompensatorLinearModel)sc.getModel(ShuntCompensatorLinearModel.class)).getGPerSection(), (XMLStreamWriter)context.getWriter());
            context.getWriter().writeAttribute(MAXIMUM_SECTION_COUNT, Integer.toString(sc.getMaximumSectionCount()));
        } else if (sc.getModelType() == ShuntCompensatorModelType.NON_LINEAR) {
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
                context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), SHUNT_NON_LINEAR_MODEL);
                for (ShuntCompensatorNonLinearModel.Section s : ((ShuntCompensatorNonLinearModel)sc.getModel(ShuntCompensatorNonLinearModel.class)).getAllSections()) {
                    context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), "section");
                    XmlUtil.writeDouble((String)"b", (double)s.getB(), (XMLStreamWriter)context.getWriter());
                    XmlUtil.writeDouble((String)"g", (double)s.getG(), (XMLStreamWriter)context.getWriter());
                }
                context.getWriter().writeEndElement();
            });
        } else {
            throw new PowsyblException("Unexpected shunt type " + sc.getModelType() + " for shunt " + sc.getId());
        }
    }

    @Override
    protected void readRootElementAttributes(ShuntCompensatorAdder adder, List<Consumer<ShuntCompensator>> toApply, NetworkXmlReaderContext context) {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> {
            String voltageRegulatorOn = context.getReader().getAttributeValue(null, "voltageRegulatorOn");
            double targetV = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetV");
            double targetDeadband = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetDeadband");
            adder.setTargetV(targetV).setTargetDeadband(targetDeadband).setVoltageRegulatorOn(Boolean.parseBoolean(voltageRegulatorOn));
        });
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> adder.setVoltageRegulatorOn(false));
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_2, context, () -> {
            double bPerSection = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)B_PER_SECTION);
            int maximumSectionCount = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)MAXIMUM_SECTION_COUNT);
            int sectionCount = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)"currentSectionCount");
            adder.setSectionCount(sectionCount);
            adder.newLinearModel().setBPerSection(bPerSection).setMaximumSectionCount(maximumSectionCount).add();
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
            Integer sectionCount = XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)"sectionCount");
            if (sectionCount != null) {
                adder.setSectionCount(sectionCount.intValue());
            }
        });
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        double p = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p");
        double q = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q");
        toApply.add(sc -> sc.getTerminal().setP(p).setQ(q));
    }

    @Override
    protected void readSubElements(String id, ShuntCompensatorAdder adder, List<Consumer<ShuntCompensator>> toApply, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "regulatingTerminal": {
                    String regId = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
                    String regSide = context.getReader().getAttributeValue(null, "side");
                    toApply.add(sc -> context.getEndTasks().add(() -> sc.setRegulatingTerminal(TerminalRefXml.resolve(regId, regSide, sc.getNetwork()))));
                    break;
                }
                case "shuntLinearModel": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, SHUNT_LINEAR_MODEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
                    double bPerSection = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)B_PER_SECTION);
                    double gPerSection = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"gPerSection");
                    int maximumSectionCount = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)MAXIMUM_SECTION_COUNT);
                    adder.newLinearModel().setBPerSection(bPerSection).setGPerSection(gPerSection).setMaximumSectionCount(maximumSectionCount).add();
                    break;
                }
                case "shuntNonLinearModel": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, SHUNT_NON_LINEAR_MODEL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_3, context);
                    ShuntCompensatorNonLinearModelAdder modelAdder = adder.newNonLinearModel();
                    XmlUtil.readUntilEndElement((String)SHUNT_NON_LINEAR_MODEL, (XMLStreamReader)context.getReader(), () -> {
                        if (!"section".equals(context.getReader().getLocalName())) {
                            throw new PowsyblException("Unknown element name <" + context.getReader().getLocalName() + "> in <" + id + ">");
                        }
                        double b = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b");
                        double g = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g");
                        modelAdder.beginSection().setB(b).setG(g).endSection();
                    });
                    modelAdder.add();
                    break;
                }
                default: {
                    super.readSubElements(id, toApply, context);
                }
            }
        });
    }
}

