/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class StaticVarCompensatorXml
extends AbstractSimpleIdentifiableXml<StaticVarCompensator, StaticVarCompensatorAdder, VoltageLevel> {
    static final StaticVarCompensatorXml INSTANCE = new StaticVarCompensatorXml();
    static final String ROOT_ELEMENT_NAME = "staticVarCompensator";
    private static final String REGULATING_TERMINAL = "regulatingTerminal";

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(StaticVarCompensator svc) {
        return svc != svc.getRegulatingTerminal().getConnectable();
    }

    @Override
    protected void writeRootElementAttributes(StaticVarCompensator svc, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"bMin", (double)svc.getBmin(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"bMax", (double)svc.getBmax(), (XMLStreamWriter)context.getWriter());
        String[] voltageSetpointName = new String[]{"voltageSetpoint"};
        String[] reactivePowerSetpointName = new String[]{"reactivePowerSetpoint"};
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_2, context, () -> {
            voltageSetpointName[0] = "voltageSetPoint";
            reactivePowerSetpointName[0] = "reactivePowerSetPoint";
        });
        XmlUtil.writeDouble((String)voltageSetpointName[0], (double)svc.getVoltageSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)reactivePowerSetpointName[0], (double)svc.getReactivePowerSetpoint(), (XMLStreamWriter)context.getWriter());
        if (svc.getRegulationMode() != null) {
            context.getWriter().writeAttribute("regulationMode", svc.getRegulationMode().name());
        }
        ConnectableXmlUtil.writeNodeOrBus(null, svc.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, svc.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(StaticVarCompensator svc, VoltageLevel vl, NetworkXmlWriterContext context) {
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(svc != svc.getRegulatingTerminal().getConnectable(), ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context, () -> TerminalRefXml.writeTerminalRef(svc.getRegulatingTerminal(), context, REGULATING_TERMINAL));
    }

    @Override
    protected StaticVarCompensatorAdder createAdder(VoltageLevel vl) {
        return vl.newStaticVarCompensator();
    }

    @Override
    protected StaticVarCompensator readRootElementAttributes(StaticVarCompensatorAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        double bMin = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"bMin");
        double bMax = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"bMax");
        String[] voltageSetpointName = new String[]{"voltageSetpoint"};
        String[] reactivePowerSetpointName = new String[]{"reactivePowerSetpoint"};
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_2, context, () -> {
            voltageSetpointName[0] = "voltageSetPoint";
            reactivePowerSetpointName[0] = "reactivePowerSetPoint";
        });
        double voltageSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)voltageSetpointName[0]);
        double reactivePowerSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)reactivePowerSetpointName[0]);
        String regulationModeStr = context.getReader().getAttributeValue(null, "regulationMode");
        StaticVarCompensator.RegulationMode regulationMode = regulationModeStr != null ? StaticVarCompensator.RegulationMode.valueOf((String)regulationModeStr) : null;
        adder.setBmin(bMin).setBmax(bMax).setVoltageSetpoint(voltageSetpoint).setReactivePowerSetpoint(reactivePowerSetpoint).setRegulationMode(regulationMode);
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        StaticVarCompensator svc = adder.add();
        ConnectableXmlUtil.readPQ(null, svc.getTerminal(), context.getReader());
        return svc;
    }

    @Override
    protected void readSubElements(StaticVarCompensator svc, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            if (context.getReader().getLocalName().equals(REGULATING_TERMINAL)) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
                String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
                String side = context.getReader().getAttributeValue(null, "side");
                context.getEndTasks().add(() -> svc.setRegulatingTerminal(TerminalRefXml.resolve(id, side, svc.getNetwork())));
            } else {
                super.readSubElements(svc, context);
            }
        });
    }
}

