/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.ThreeWindingsTransformerXml;
import com.powsybl.iidm.xml.TwoWindingsTransformerXml;
import com.powsybl.iidm.xml.VoltageLevelXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

class SubstationXml
extends AbstractSimpleIdentifiableXml<Substation, SubstationAdder, Network> {
    static final SubstationXml INSTANCE = new SubstationXml();
    static final String ROOT_ELEMENT_NAME = "substation";
    private static final String COUNTRY = "country";

    SubstationXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(Substation s) {
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Substation s, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        Optional country = s.getCountry();
        if (country.isPresent()) {
            context.getWriter().writeAttribute(COUNTRY, context.getAnonymizer().anonymizeCountry((Country)country.get()).toString());
        }
        if (s.getTso() != null) {
            context.getWriter().writeAttribute("tso", context.getAnonymizer().anonymizeString(s.getTso()));
        }
        if (!s.getGeographicalTags().isEmpty()) {
            context.getWriter().writeAttribute("geographicalTags", s.getGeographicalTags().stream().map(tag -> context.getAnonymizer().anonymizeString((String)tag)).collect(Collectors.joining(",")));
        }
    }

    @Override
    protected void writeSubElements(Substation s, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Object vl : IidmXmlUtil.sorted(s.getVoltageLevels(), context.getOptions())) {
            VoltageLevelXml.INSTANCE.write(vl, null, context);
        }
        Iterable<TwoWindingsTransformer> twts = IidmXmlUtil.sorted(s.getTwoWindingsTransformers(), context.getOptions());
        for (TwoWindingsTransformer twt : twts) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            TwoWindingsTransformerXml.INSTANCE.write(twt, null, context);
        }
        Iterable<ThreeWindingsTransformer> twts2 = IidmXmlUtil.sorted(s.getThreeWindingsTransformers(), context.getOptions());
        for (ThreeWindingsTransformer twt : twts2) {
            if (!context.getFilter().test((Connectable<?>)twt)) continue;
            ThreeWindingsTransformerXml.INSTANCE.write(twt, null, context);
        }
    }

    @Override
    protected SubstationAdder createAdder(Network network) {
        return network.newSubstation();
    }

    @Override
    protected Substation readRootElementAttributes(SubstationAdder adder, Network network, NetworkXmlReaderContext context) {
        Country country = Optional.ofNullable(context.getReader().getAttributeValue(null, COUNTRY)).map(c -> context.getAnonymizer().deanonymizeCountry(Country.valueOf((String)c))).orElse(null);
        String tso = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "tso"));
        String geographicalTags = context.getReader().getAttributeValue(null, "geographicalTags");
        if (geographicalTags != null) {
            adder.setGeographicalTags((String[])Arrays.stream(geographicalTags.split(",")).map(tag -> context.getAnonymizer().deanonymizeString((String)tag)).toArray(String[]::new));
        }
        return adder.setCountry(country).setTso(tso).add();
    }

    @Override
    protected void readSubElements(Substation s, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "voltageLevel": {
                    VoltageLevelXml.INSTANCE.read(s, context);
                    break;
                }
                case "twoWindingsTransformer": {
                    TwoWindingsTransformerXml.INSTANCE.read(s, context);
                    break;
                }
                case "threeWindingsTransformer": {
                    ThreeWindingsTransformerXml.INSTANCE.read(s, context);
                    break;
                }
                default: {
                    super.readSubElements(s, context);
                }
            }
        });
    }
}

