/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class TerminalRefXml {
    private static final String ID = "id";
    private static final String SIDE = "side";

    public static void writeTerminalRef(Terminal t, NetworkXmlWriterContext context, String elementName) throws XMLStreamException {
        TerminalRefXml.writeTerminalRef(t, context, context.getVersion().getNamespaceURI(context.isValid()), elementName);
    }

    public static void writeTerminalRef(Terminal t, NetworkXmlWriterContext context, String namespace, String elementName) throws XMLStreamException {
        TerminalRefXml.writeTerminalRef(t, context, namespace, elementName, context.getWriter());
    }

    public static void writeTerminalRef(Terminal t, NetworkXmlWriterContext context, String namespace, String elementName, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEmptyElement(namespace, elementName);
        TerminalRefXml.writeTerminalRefAttribute(t, context, writer);
    }

    public static void writeTerminalRefAttribute(Terminal t, NetworkXmlWriterContext context) throws XMLStreamException {
        TerminalRefXml.writeTerminalRefAttribute(t, context, context.getWriter());
    }

    public static void writeTerminalRefAttribute(Terminal t, NetworkXmlWriterContext context, XMLStreamWriter writer) throws XMLStreamException {
        Connectable c = t.getConnectable();
        if (!context.getFilter().test(c)) {
            throw new PowsyblException("Oups, terminal ref point to a filtered equipment " + c.getId());
        }
        if (t.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER && context.getOptions().getTopologyLevel() != TopologyLevel.NODE_BREAKER && t.getConnectable() instanceof BusbarSection) {
            throw new PowsyblException(String.format("Terminal ref should not point to a busbar section (here %s). Try to export in node-breaker or delete this terminal ref.", t.getConnectable().getId()));
        }
        writer.writeAttribute(ID, context.getAnonymizer().anonymizeString(c.getId()));
        Terminal.getConnectableSide((Terminal)t).ifPresent(side -> {
            try {
                writer.writeAttribute(SIDE, side.name());
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
    }

    public static Terminal readTerminal(NetworkXmlReaderContext context, Network n) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, ID));
        String side = context.getReader().getAttributeValue(null, SIDE);
        return TerminalRefXml.resolve(id, side, n);
    }

    public static Terminal resolve(String id, String sideText, Network network) {
        ThreeSides side = sideText == null ? ThreeSides.ONE : ThreeSides.valueOf((String)sideText);
        return TerminalRefXml.resolve(id, side, network);
    }

    public static Terminal resolve(String id, ThreeSides side, Network network) {
        Identifiable identifiable = network.getIdentifiable(id);
        if (identifiable == null) {
            throw new PowsyblException("Terminal reference identifiable not found: '" + id + "'");
        }
        return Terminal.getTerminal((Identifiable)identifiable, (ThreeSides)side);
    }

    private TerminalRefXml() {
    }
}

