/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.xml.AbstractTransformerXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class ThreeWindingsTransformerXml
extends AbstractTransformerXml<ThreeWindingsTransformer, ThreeWindingsTransformerAdder> {
    static final ThreeWindingsTransformerXml INSTANCE = new ThreeWindingsTransformerXml();
    static final String ROOT_ELEMENT_NAME = "threeWindingsTransformer";
    private static final String RATIO_TAP_CHANGER_1 = "ratioTapChanger1";
    private static final String PHASE_TAP_CHANGER_1 = "phaseTapChanger1";
    private static final String RATIO_TAP_CHANGER_2 = "ratioTapChanger2";
    private static final String PHASE_TAP_CHANGER_2 = "phaseTapChanger2";
    private static final String RATIO_TAP_CHANGER_3 = "ratioTapChanger3";
    private static final String PHASE_TAP_CHANGER_3 = "phaseTapChanger3";

    ThreeWindingsTransformerXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(ThreeWindingsTransformer twt) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    protected boolean hasSubElements(ThreeWindingsTransformer twt, NetworkXmlWriterContext context) {
        return twt.getLeg1().hasRatioTapChanger() && context.getVersion().compareTo(IidmXmlVersion.V_1_1) > 0 || twt.getLeg2().hasRatioTapChanger() || twt.getLeg3().hasRatioTapChanger() || twt.getLeg1().hasPhaseTapChanger() && context.getVersion().compareTo(IidmXmlVersion.V_1_1) > 0 || twt.getLeg2().hasPhaseTapChanger() && context.getVersion().compareTo(IidmXmlVersion.V_1_1) > 0 || twt.getLeg3().hasPhaseTapChanger() && context.getVersion().compareTo(IidmXmlVersion.V_1_1) > 0 || ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)twt.getLeg1(), context) || ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)twt.getLeg2(), context) || ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)twt.getLeg3(), context);
    }

    @Override
    protected void writeRootElementAttributes(ThreeWindingsTransformer twt, Substation s, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"r1", (double)twt.getLeg1().getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x1", (double)twt.getLeg1().getX(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"g1", (double)twt.getLeg1().getG(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"b1", (double)twt.getLeg1().getB(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"ratedU1", (double)twt.getLeg1().getRatedU(), (XMLStreamWriter)context.getWriter());
        ThreeWindingsTransformerXml.writeRatedS("ratedS1", twt.getLeg1().getRatedS(), context);
        XmlUtil.writeDouble((String)"r2", (double)twt.getLeg2().getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x2", (double)twt.getLeg2().getX(), (XMLStreamWriter)context.getWriter());
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "g2", twt.getLeg2().getG(), 0.0, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "b2", twt.getLeg2().getB(), 0.0, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        XmlUtil.writeDouble((String)"ratedU2", (double)twt.getLeg2().getRatedU(), (XMLStreamWriter)context.getWriter());
        ThreeWindingsTransformerXml.writeRatedS("ratedS2", twt.getLeg2().getRatedS(), context);
        XmlUtil.writeDouble((String)"r3", (double)twt.getLeg3().getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x3", (double)twt.getLeg3().getX(), (XMLStreamWriter)context.getWriter());
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "g3", twt.getLeg3().getG(), 0.0, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "b3", twt.getLeg3().getB(), 0.0, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        XmlUtil.writeDouble((String)"ratedU3", (double)twt.getLeg3().getRatedU(), (XMLStreamWriter)context.getWriter());
        ThreeWindingsTransformerXml.writeRatedS("ratedS3", twt.getLeg3().getRatedS(), context);
        IidmXmlUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "ratedU0", twt.getRatedU0(), twt.getLeg1().getRatedU(), IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        ConnectableXmlUtil.writeNodeOrBus(1, twt.getLeg1().getTerminal(), context);
        ConnectableXmlUtil.writeNodeOrBus(2, twt.getLeg2().getTerminal(), context);
        ConnectableXmlUtil.writeNodeOrBus(3, twt.getLeg3().getTerminal(), context);
        if (context.getOptions().isWithBranchSV()) {
            ConnectableXmlUtil.writePQ(1, twt.getLeg1().getTerminal(), context.getWriter());
            ConnectableXmlUtil.writePQ(2, twt.getLeg2().getTerminal(), context.getWriter());
            ConnectableXmlUtil.writePQ(3, twt.getLeg3().getTerminal(), context.getWriter());
        }
    }

    @Override
    protected void writeSubElements(ThreeWindingsTransformer twt, Substation s, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg1().hasRatioTapChanger(), ROOT_ELEMENT_NAME, RATIO_TAP_CHANGER_1, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context, () -> ThreeWindingsTransformerXml.writeRatioTapChanger(twt.getLeg1().getRatioTapChanger(), 1, context));
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg1().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_1, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context, () -> ThreeWindingsTransformerXml.writePhaseTapChanger(twt.getLeg1().getPhaseTapChanger(), 1, context));
        ThreeWindingsTransformerXml.writeRatioTapChanger(twt.getLeg2().getRatioTapChanger(), 2, context);
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg2().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_2, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context, () -> ThreeWindingsTransformerXml.writePhaseTapChanger(twt.getLeg2().getPhaseTapChanger(), 2, context));
        ThreeWindingsTransformerXml.writeRatioTapChanger(twt.getLeg3().getRatioTapChanger(), 3, context);
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg3().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_3, IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_1, context, () -> ThreeWindingsTransformerXml.writePhaseTapChanger(twt.getLeg3().getPhaseTapChanger(), 3, context));
        int[] i = new int[]{1};
        for (ThreeWindingsTransformer.Leg leg : twt.getLegs()) {
            Optional currentLimits;
            Optional apparentPowerLimits;
            Optional activePowerLimits = leg.getActivePowerLimits();
            if (activePowerLimits.isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(i[0], (ActivePowerLimits)activePowerLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((apparentPowerLimits = leg.getApparentPowerLimits()).isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(i[0], (ApparentPowerLimits)apparentPowerLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((currentLimits = leg.getCurrentLimits()).isPresent()) {
                ConnectableXmlUtil.writeCurrentLimits((Integer)i[0], (CurrentLimits)currentLimits.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
            }
            i[0] = i[0] + 1;
        }
    }

    private static void writeRatioTapChanger(RatioTapChanger rtc, int index, NetworkXmlWriterContext context) throws XMLStreamException {
        if (rtc != null) {
            ThreeWindingsTransformerXml.writeRatioTapChanger("ratioTapChanger" + index, rtc, context);
        }
    }

    private static void writePhaseTapChanger(PhaseTapChanger ptc, int index, NetworkXmlWriterContext context) throws XMLStreamException {
        if (ptc != null) {
            ThreeWindingsTransformerXml.writePhaseTapChanger("phaseTapChanger" + index, ptc, context);
        }
    }

    @Override
    protected ThreeWindingsTransformerAdder createAdder(Substation s) {
        return s.newThreeWindingsTransformer();
    }

    @Override
    protected ThreeWindingsTransformer readRootElementAttributes(ThreeWindingsTransformerAdder adder, Substation s, NetworkXmlReaderContext context) {
        double r1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r1");
        double x1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x1");
        double g1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g1");
        double b1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b1");
        double ratedU1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU1");
        double r2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r2");
        double x2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x2");
        double ratedU2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU2");
        double r3 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r3");
        double x3 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x3");
        double ratedU3 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU3");
        ThreeWindingsTransformerAdder.LegAdder legAdder1 = adder.newLeg1().setR(r1).setX(x1).setG(g1).setB(b1).setRatedU(ratedU1);
        ThreeWindingsTransformerAdder.LegAdder legAdder2 = adder.newLeg2().setR(r2).setX(x2).setRatedU(ratedU2);
        ThreeWindingsTransformerAdder.LegAdder legAdder3 = adder.newLeg3().setR(r3).setX(x3).setRatedU(ratedU3);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_1, context, () -> {
            double ratedU0 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU0");
            adder.setRatedU0(ratedU0);
            double g2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g2");
            double b2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b2");
            legAdder2.setG(g2).setB(b2);
            double g3 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g3");
            double b3 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b3");
            legAdder3.setG(g3).setB(b3);
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_2, context, () -> {
            ThreeWindingsTransformerXml.readRatedS("ratedS1", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder1).setRatedS(arg_0));
            ThreeWindingsTransformerXml.readRatedS("ratedS2", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder2).setRatedS(arg_0));
            ThreeWindingsTransformerXml.readRatedS("ratedS3", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder3).setRatedS(arg_0));
        });
        ConnectableXmlUtil.readNodeOrBus(1, legAdder1, context);
        ConnectableXmlUtil.readNodeOrBus(2, legAdder2, context);
        ConnectableXmlUtil.readNodeOrBus(3, legAdder3, context);
        legAdder1.add();
        legAdder2.add();
        legAdder3.add();
        ThreeWindingsTransformer twt = adder.add();
        ConnectableXmlUtil.readPQ(1, twt.getLeg1().getTerminal(), context.getReader());
        ConnectableXmlUtil.readPQ(2, twt.getLeg2().getTerminal(), context.getReader());
        ConnectableXmlUtil.readPQ(3, twt.getLeg3().getTerminal(), context.getReader());
        return twt;
    }

    @Override
    protected void readSubElements(ThreeWindingsTransformer tx, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "activePowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(1, tx.getLeg1().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(1, tx.getLeg1().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    ConnectableXmlUtil.readCurrentLimits(1, tx.getLeg1().newCurrentLimits(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(2, tx.getLeg2().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(2, tx.getLeg2().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    ConnectableXmlUtil.readCurrentLimits(2, tx.getLeg2().newCurrentLimits(), context.getReader());
                    break;
                }
                case "activePowerLimits3": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits3", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(3, tx.getLeg3().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits3": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits3", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(3, tx.getLeg3().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits3": {
                    ConnectableXmlUtil.readCurrentLimits(3, tx.getLeg3().newCurrentLimits(), context.getReader());
                    break;
                }
                case "ratioTapChanger1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, RATIO_TAP_CHANGER_1, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
                    ThreeWindingsTransformerXml.readRatioTapChanger(1, tx.getLeg1(), context);
                    break;
                }
                case "phaseTapChanger1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_1, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
                    ThreeWindingsTransformerXml.readPhaseTapChanger(1, tx.getLeg1(), context);
                    break;
                }
                case "ratioTapChanger2": {
                    ThreeWindingsTransformerXml.readRatioTapChanger(2, tx.getLeg2(), context);
                    break;
                }
                case "phaseTapChanger2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_2, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
                    ThreeWindingsTransformerXml.readPhaseTapChanger(2, tx.getLeg2(), context);
                    break;
                }
                case "ratioTapChanger3": {
                    ThreeWindingsTransformerXml.readRatioTapChanger(3, tx.getLeg3(), context);
                    break;
                }
                case "phaseTapChanger3": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_3, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
                    ThreeWindingsTransformerXml.readPhaseTapChanger(3, tx.getLeg3(), context);
                    break;
                }
                default: {
                    super.readSubElements(tx, context);
                }
            }
        });
    }
}

