/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TieLineXml
extends AbstractSimpleIdentifiableXml<TieLine, TieLineAdder, Network> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieLineXml.class);
    static final TieLineXml INSTANCE = new TieLineXml();
    static final String ROOT_ELEMENT_NAME = "tieLine";

    TieLineXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(TieLine tl) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    protected boolean hasSubElements(TieLine tl, NetworkXmlWriterContext context) {
        return (ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)tl.getDanglingLine1(), context) || ConnectableXmlUtil.hasValidOperationalLimits((FlowsLimitsHolder)tl.getDanglingLine2(), context)) && context.getVersion().compareTo(IidmXmlVersion.V_1_10) < 0;
    }

    private static void writeDanglingLine(DanglingLine danglingLine, NetworkXmlWriterContext context, int side) throws XMLStreamException {
        Boundary boundary = danglingLine.getBoundary();
        context.getWriter().writeAttribute("id_" + side, context.getAnonymizer().anonymizeString(danglingLine.getId()));
        danglingLine.getOptionalName().ifPresent(name -> {
            try {
                context.getWriter().writeAttribute("name_" + side, context.getAnonymizer().anonymizeString((String)name));
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
        });
        XmlUtil.writeDouble((String)("r_" + side), (double)danglingLine.getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)("x_" + side), (double)danglingLine.getX(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)("g1_" + side), (double)(danglingLine.getG() / 2.0), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)("b1_" + side), (double)(danglingLine.getB() / 2.0), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)("g2_" + side), (double)(danglingLine.getG() / 2.0), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)("b2_" + side), (double)(danglingLine.getB() / 2.0), (XMLStreamWriter)context.getWriter());
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_4, context, () -> {
            XmlUtil.writeDouble((String)("xnodeP_" + side), (double)boundary.getP(), (XMLStreamWriter)context.getWriter());
            XmlUtil.writeDouble((String)("xnodeQ_" + side), (double)boundary.getQ(), (XMLStreamWriter)context.getWriter());
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> XmlUtil.writeOptionalBoolean((String)("fictitious_" + side), (boolean)danglingLine.isFictitious(), (boolean)false, (XMLStreamWriter)context.getWriter()));
    }

    @Override
    protected void writeRootElementAttributes(TieLine tl, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_10, context, () -> {
            context.getWriter().writeAttribute("danglingLineId1", context.getAnonymizer().anonymizeString(tl.getDanglingLine1().getId()));
            context.getWriter().writeAttribute("danglingLineId2", context.getAnonymizer().anonymizeString(tl.getDanglingLine2().getId()));
        });
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_9, context, () -> {
            if (tl.getPairingKey() != null) {
                context.getWriter().writeAttribute("ucteXnodeCode", tl.getPairingKey());
            }
            ConnectableXmlUtil.writeNodeOrBus(1, tl.getDanglingLine1().getTerminal(), context);
            ConnectableXmlUtil.writeNodeOrBus(2, tl.getDanglingLine2().getTerminal(), context);
            if (context.getOptions().isWithBranchSV()) {
                ConnectableXmlUtil.writePQ(1, tl.getDanglingLine1().getTerminal(), context.getWriter());
                ConnectableXmlUtil.writePQ(2, tl.getDanglingLine2().getTerminal(), context.getWriter());
            }
            TieLineXml.writeDanglingLine(tl.getDanglingLine1(), context, 1);
            TieLineXml.writeDanglingLine(tl.getDanglingLine2(), context, 2);
        });
    }

    @Override
    protected void writeSubElements(TieLine tl, Network n, NetworkXmlWriterContext context) throws XMLStreamException {
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_9, context, () -> {
            Optional currentLimits2;
            Optional apparentPowerLimits2;
            Optional activePowerLimits2;
            Optional currentLimits1;
            Optional apparentPowerLimits1;
            Optional activePowerLimits1 = tl.getDanglingLine1().getActivePowerLimits();
            if (activePowerLimits1.isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((apparentPowerLimits1 = tl.getDanglingLine1().getApparentPowerLimits()).isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((currentLimits1 = tl.getDanglingLine1().getCurrentLimits()).isPresent()) {
                ConnectableXmlUtil.writeCurrentLimits((Integer)1, (CurrentLimits)currentLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
            }
            if ((activePowerLimits2 = tl.getDanglingLine2().getActivePowerLimits()).isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((apparentPowerLimits2 = tl.getDanglingLine2().getApparentPowerLimits()).isPresent()) {
                IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            }
            if ((currentLimits2 = tl.getDanglingLine2().getCurrentLimits()).isPresent()) {
                ConnectableXmlUtil.writeCurrentLimits((Integer)2, (CurrentLimits)currentLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
            }
        });
    }

    @Override
    protected TieLineAdder createAdder(Network n) {
        return n.newTieLine();
    }

    @Override
    protected TieLine readRootElementAttributes(TieLineAdder adder, Network network, NetworkXmlReaderContext context) {
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_9, context, () -> adder.setDanglingLine1(TieLineXml.readDanglingLine(network, context, 1)).setDanglingLine2(TieLineXml.readDanglingLine(network, context, 2)));
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_10, context, () -> {
            String dl1Id = context.getReader().getAttributeValue(null, "danglingLineId1");
            String dl2Id = context.getReader().getAttributeValue(null, "danglingLineId2");
            adder.setDanglingLine1(dl1Id).setDanglingLine2(dl2Id);
        });
        TieLine tl = adder.add();
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_4, context, () -> {
            double dl1BoundaryP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xnodeP_1");
            double dl2BoundaryP = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xnodeP_2");
            double dl1BoundaryQ = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xnodeQ_1");
            double dl2BoundaryQ = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xnodeQ_2");
            TieLineXml.checkBoundaryValue(dl1BoundaryP, tl.getDanglingLine1().getBoundary().getP(), "xnodeP_1", tl.getId());
            TieLineXml.checkBoundaryValue(dl2BoundaryP, tl.getDanglingLine2().getBoundary().getP(), "xnodeP_2", tl.getId());
            TieLineXml.checkBoundaryValue(dl1BoundaryQ, tl.getDanglingLine1().getBoundary().getQ(), "xnodeQ_1", tl.getId());
            TieLineXml.checkBoundaryValue(dl2BoundaryQ, tl.getDanglingLine2().getBoundary().getQ(), "xnodeQ_2", tl.getId());
        });
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_9, context, () -> {
            double p1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p1");
            double q1 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q1");
            double p2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"p2");
            double q2 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"q2");
            tl.getDanglingLine1().getTerminal().setP(p1).setQ(q1);
            tl.getDanglingLine2().getTerminal().setP(p2).setQ(q2);
        });
        return tl;
    }

    private static String readDanglingLine(Network network, NetworkXmlReaderContext context, int side) {
        String voltageLevelId = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "voltageLevelId" + side));
        String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id_" + side));
        String name = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "name_" + side));
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("r_" + side));
        double x = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("x_" + side));
        double g1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("g1_" + side));
        double b1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("b1_" + side));
        double g2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("g2_" + side));
        double b2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)("b2_" + side));
        DanglingLineAdder adder = ((DanglingLineAdder)((DanglingLineAdder)network.getVoltageLevel(voltageLevelId).newDanglingLine().setId(id)).setName(name)).setR(r).setX(x).setG(g1 + g2).setB(b1 + b2).setP0(0.0).setQ0(0.0);
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_10, context, () -> {
            String pairingKey = context.getReader().getAttributeValue(null, "ucteXnodeCode");
            adder.setPairingKey(pairingKey);
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> {
            String pairingKey = context.getReader().getAttributeValue(null, "pairingKey");
            adder.setPairingKey(pairingKey);
        });
        ConnectableXmlUtil.readNodeOrBus(adder, String.valueOf(side), context);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_3, context, () -> {
            boolean fictitious = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)("fictitious_" + side), (boolean)false);
            adder.setFictitious(fictitious);
        });
        DanglingLine dl = adder.add();
        return dl.getId();
    }

    @Override
    protected void readSubElements(TieLine tl, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "activePowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(1, tl.getDanglingLine1().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(1, tl.getDanglingLine1().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    ConnectableXmlUtil.readCurrentLimits(1, tl.getDanglingLine1().newCurrentLimits(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(2, tl.getDanglingLine2().newActivePowerLimits(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(2, tl.getDanglingLine2().newApparentPowerLimits(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    IidmXmlUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_9, context);
                    ConnectableXmlUtil.readCurrentLimits(2, tl.getDanglingLine2().newCurrentLimits(), context.getReader());
                    break;
                }
                default: {
                    super.readSubElements(tl, context);
                }
            }
        });
    }

    private static void checkBoundaryValue(double imported, double calculated, String name, String tlId) {
        if (!Double.isNaN(imported) && imported != calculated) {
            LOGGER.info("{} of TieLine {} is recalculated. Its imported value is not used (imported value = {}; calculated value = {})", new Object[]{name, tlId, imported, calculated});
        }
    }
}

