/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.xml.AbstractTransformerXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class TwoWindingsTransformerXml
extends AbstractTransformerXml<TwoWindingsTransformer, TwoWindingsTransformerAdder> {
    static final TwoWindingsTransformerXml INSTANCE = new TwoWindingsTransformerXml();
    static final String ROOT_ELEMENT_NAME = "twoWindingsTransformer";

    TwoWindingsTransformerXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(TwoWindingsTransformer twt) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    protected boolean hasSubElements(TwoWindingsTransformer twt, NetworkXmlWriterContext context) {
        return ConnectableXmlUtil.hasValidOperationalLimits(twt, context) || twt.hasRatioTapChanger() || twt.hasPhaseTapChanger();
    }

    @Override
    protected void writeRootElementAttributes(TwoWindingsTransformer twt, Substation s, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"r", (double)twt.getR(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"x", (double)twt.getX(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"g", (double)twt.getG(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"b", (double)twt.getB(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"ratedU1", (double)twt.getRatedU1(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"ratedU2", (double)twt.getRatedU2(), (XMLStreamWriter)context.getWriter());
        TwoWindingsTransformerXml.writeRatedS("ratedS", twt.getRatedS(), context);
        ConnectableXmlUtil.writeNodeOrBus(1, twt.getTerminal1(), context);
        ConnectableXmlUtil.writeNodeOrBus(2, twt.getTerminal2(), context);
        if (context.getOptions().isWithBranchSV()) {
            ConnectableXmlUtil.writePQ(1, twt.getTerminal1(), context.getWriter());
            ConnectableXmlUtil.writePQ(2, twt.getTerminal2(), context.getWriter());
        }
    }

    @Override
    protected void writeSubElements(TwoWindingsTransformer twt, Substation s, NetworkXmlWriterContext context) throws XMLStreamException {
        Optional currentLimits2;
        Optional apparentPowerLimits2;
        Optional activePowerLimits2;
        Optional currentLimits1;
        Optional apparentPowerLimits1;
        Optional activePowerLimits1;
        PhaseTapChanger ptc;
        RatioTapChanger rtc = twt.getRatioTapChanger();
        if (rtc != null) {
            TwoWindingsTransformerXml.writeRatioTapChanger("ratioTapChanger", rtc, context);
        }
        if ((ptc = twt.getPhaseTapChanger()) != null) {
            TwoWindingsTransformerXml.writePhaseTapChanger("phaseTapChanger", ptc, context);
        }
        if ((activePowerLimits1 = twt.getActivePowerLimits1()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(1, (ActivePowerLimits)activePowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits1 = twt.getApparentPowerLimits1()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(1, (ApparentPowerLimits)apparentPowerLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits1 = twt.getCurrentLimits1()).isPresent()) {
            ConnectableXmlUtil.writeCurrentLimits((Integer)1, (CurrentLimits)currentLimits1.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
        if ((activePowerLimits2 = twt.getActivePowerLimits2()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeActivePowerLimits(2, (ActivePowerLimits)activePowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((apparentPowerLimits2 = twt.getApparentPowerLimits2()).isPresent()) {
            IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
            IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.writeApparentPowerLimits(2, (ApparentPowerLimits)apparentPowerLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
        }
        if ((currentLimits2 = twt.getCurrentLimits2()).isPresent()) {
            ConnectableXmlUtil.writeCurrentLimits((Integer)2, (CurrentLimits)currentLimits2.get(), context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        }
    }

    @Override
    protected TwoWindingsTransformerAdder createAdder(Substation s) {
        return s.newTwoWindingsTransformer();
    }

    @Override
    protected TwoWindingsTransformer readRootElementAttributes(TwoWindingsTransformerAdder adder, Substation s, NetworkXmlReaderContext context) {
        double r = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"r");
        double x = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"x");
        double g = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"g");
        double b = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"b");
        double ratedU1 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU1");
        double ratedU2 = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"ratedU2");
        adder.setR(r).setX(x).setG(g).setB(b).setRatedU1(ratedU1).setRatedU2(ratedU2);
        TwoWindingsTransformerXml.readRatedS("ratedS", context, arg_0 -> ((TwoWindingsTransformerAdder)adder).setRatedS(arg_0));
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        TwoWindingsTransformer twt = adder.add();
        ConnectableXmlUtil.readPQ(1, twt.getTerminal1(), context.getReader());
        ConnectableXmlUtil.readPQ(2, twt.getTerminal2(), context.getReader());
        return twt;
    }

    @Override
    protected void readSubElements(TwoWindingsTransformer twt, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "activePowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(1, twt.newActivePowerLimits1(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(1, twt.newApparentPowerLimits1(), context.getReader()));
                    break;
                }
                case "currentLimits1": {
                    ConnectableXmlUtil.readCurrentLimits(1, twt.newCurrentLimits1(), context.getReader());
                    break;
                }
                case "activePowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readActivePowerLimits(2, twt.newActivePowerLimits2(), context.getReader()));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, context);
                    IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_5, context, () -> ConnectableXmlUtil.readApparentPowerLimits(2, twt.newApparentPowerLimits2(), context.getReader()));
                    break;
                }
                case "currentLimits2": {
                    ConnectableXmlUtil.readCurrentLimits(2, twt.newCurrentLimits2(), context.getReader());
                    break;
                }
                case "ratioTapChanger": {
                    TwoWindingsTransformerXml.readRatioTapChanger(twt, context);
                    break;
                }
                case "phaseTapChanger": {
                    TwoWindingsTransformerXml.readPhaseTapChanger(twt, context);
                    break;
                }
                default: {
                    super.readSubElements(twt, context);
                }
            }
        });
    }
}

