/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageAngleLimitAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class VoltageAngleLimitXml {
    private static final String VOLTAGE_ANGLE_LIMIT = "voltageAngleLimit";
    private static final String ID = "id";
    private static final String LOW_LIMIT = "lowLimit";
    private static final String HIGH_LIMIT = "highLimit";
    private static final String FROM = "from";
    private static final String TO = "to";

    public static void write(VoltageAngleLimit voltageAngleLimit, NetworkXmlWriterContext context) {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> {
            context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), VOLTAGE_ANGLE_LIMIT);
            try {
                context.getWriter().writeAttribute(ID, context.getAnonymizer().anonymizeString(voltageAngleLimit.getId()));
            }
            catch (XMLStreamException e) {
                throw new UncheckedXmlStreamException(e);
            }
            voltageAngleLimit.getLowLimit().ifPresent(low -> {
                try {
                    XmlUtil.writeDouble((String)LOW_LIMIT, (double)low, (XMLStreamWriter)context.getWriter());
                }
                catch (XMLStreamException e) {
                    throw new UncheckedXmlStreamException(e);
                }
            });
            voltageAngleLimit.getHighLimit().ifPresent(high -> {
                try {
                    XmlUtil.writeDouble((String)HIGH_LIMIT, (double)high, (XMLStreamWriter)context.getWriter());
                }
                catch (XMLStreamException e) {
                    throw new UncheckedXmlStreamException(e);
                }
            });
            TerminalRefXml.writeTerminalRef(voltageAngleLimit.getTerminalFrom(), context, FROM);
            TerminalRefXml.writeTerminalRef(voltageAngleLimit.getTerminalTo(), context, TO);
            context.getWriter().writeEndElement();
        });
    }

    public static void read(Network network, NetworkXmlReaderContext context) {
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_11, context, () -> {
            String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, ID));
            double lowLimit = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)LOW_LIMIT);
            double highLimit = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)HIGH_LIMIT);
            VoltageAngleLimitAdder adder = network.newVoltageAngleLimit();
            adder.setId(id);
            if (!Double.isNaN(lowLimit)) {
                adder.setLowLimit(lowLimit);
            }
            if (!Double.isNaN(highLimit)) {
                adder.setHighLimit(highLimit);
            }
            XmlUtil.readUntilEndElement((String)VOLTAGE_ANGLE_LIMIT, (XMLStreamReader)context.getReader(), () -> {
                if (context.getReader().getLocalName().equals(FROM)) {
                    Terminal from = TerminalRefXml.readTerminal(context, network);
                    adder.from(from);
                } else if (context.getReader().getLocalName().equals(TO)) {
                    Terminal to = TerminalRefXml.readTerminal(context, network);
                    adder.to(to);
                }
            });
            adder.add();
        });
    }

    private VoltageAngleLimitXml() {
    }
}

