/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.BatteryXml;
import com.powsybl.iidm.xml.BusBreakerViewSwitchXml;
import com.powsybl.iidm.xml.BusXml;
import com.powsybl.iidm.xml.BusbarSectionXml;
import com.powsybl.iidm.xml.DanglingLineXml;
import com.powsybl.iidm.xml.GeneratorXml;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.LccConverterStationXml;
import com.powsybl.iidm.xml.LoadXml;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.NodeBreakerViewInternalConnectionXml;
import com.powsybl.iidm.xml.NodeBreakerViewSwitchXml;
import com.powsybl.iidm.xml.PropertiesXml;
import com.powsybl.iidm.xml.ShuntXml;
import com.powsybl.iidm.xml.StaticVarCompensatorXml;
import com.powsybl.iidm.xml.VscConverterStationXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VoltageLevelXml
extends AbstractSimpleIdentifiableXml<VoltageLevel, VoltageLevelAdder, Container<? extends Identifiable<?>>> {
    static final VoltageLevelXml INSTANCE = new VoltageLevelXml();
    static final String ROOT_ELEMENT_NAME = "voltageLevel";
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltageLevelXml.class);
    private static final String NODE_BREAKER_TOPOLOGY_ELEMENT_NAME = "nodeBreakerTopology";
    private static final String BUS_BREAKER_TOPOLOGY_ELEMENT_NAME = "busBreakerTopology";
    private static final String NODE_COUNT = "nodeCount";
    private static final String UNEXPECTED_ELEMENT = "Unexpected element: ";

    VoltageLevelXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(VoltageLevel vl) {
        return true;
    }

    @Override
    protected void writeRootElementAttributes(VoltageLevel vl, Container<? extends Identifiable<?>> c, NetworkXmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"nominalV", (double)vl.getNominalV(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"lowVoltageLimit", (double)vl.getLowVoltageLimit(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"highVoltageLimit", (double)vl.getHighVoltageLimit(), (XMLStreamWriter)context.getWriter());
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)vl.getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        context.getWriter().writeAttribute("topologyKind", topologyLevel.getTopologyKind().name());
    }

    @Override
    protected void writeSubElements(VoltageLevel vl, Container<? extends Identifiable<?>> c, NetworkXmlWriterContext context) throws XMLStreamException {
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)vl.getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        switch (topologyLevel) {
            case NODE_BREAKER: {
                this.writeNodeBreakerTopology(vl, context);
                break;
            }
            case BUS_BREAKER: {
                this.writeBusBreakerTopology(vl, context);
                break;
            }
            case BUS_BRANCH: {
                this.writeBusBranchTopology(vl, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TopologyLevel value: " + topologyLevel);
            }
        }
        this.writeGenerators(vl, context);
        this.writeBatteries(vl, context);
        this.writeLoads(vl, context);
        this.writeShuntCompensators(vl, context);
        this.writeDanglingLines(vl, context);
        this.writeStaticVarCompensators(vl, context);
        this.writeVscConverterStations(vl, context);
        this.writeLccConverterStations(vl, context);
    }

    private void writeNodeBreakerTopology(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), NODE_BREAKER_TOPOLOGY_ELEMENT_NAME);
        IidmXmlUtil.writeIntAttributeUntilMaximumVersion(NODE_COUNT, vl.getNodeBreakerView().getMaximumNodeIndex() + 1, IidmXmlVersion.V_1_1, context);
        for (BusbarSection bs : IidmXmlUtil.sorted(vl.getNodeBreakerView().getBusbarSections(), context.getOptions())) {
            BusbarSectionXml.INSTANCE.write(bs, null, context);
        }
        for (Switch sw : IidmXmlUtil.sorted(vl.getNodeBreakerView().getSwitches(), context.getOptions())) {
            NodeBreakerViewSwitchXml.INSTANCE.write(sw, vl, context);
        }
        this.writeNodeBreakerTopologyInternalConnections(vl, context);
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_1, context, () -> {
            Map nodesByBus = Networks.getNodesByBus((VoltageLevel)vl);
            IidmXmlUtil.sorted(vl.getBusView().getBusStream(), context.getOptions()).filter(bus -> !Double.isNaN(bus.getV()) || !Double.isNaN(bus.getAngle())).forEach(bus -> {
                Set nodes = (Set)nodesByBus.get(bus.getId());
                VoltageLevelXml.writeCalculatedBus(bus, nodes, context);
            });
        });
        IidmXmlUtil.runFromMinimumVersion(IidmXmlVersion.V_1_8, context, () -> {
            for (int node : vl.getNodeBreakerView().getNodes()) {
                double fictP0 = vl.getNodeBreakerView().getFictitiousP0(node);
                double fictQ0 = vl.getNodeBreakerView().getFictitiousQ0(node);
                if (fictP0 == 0.0 && fictQ0 == 0.0) continue;
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), "inj");
                XmlUtil.writeInt((String)"node", (int)node, (XMLStreamWriter)context.getWriter());
                XmlUtil.writeOptionalDouble((String)"fictitiousP0", (double)fictP0, (double)0.0, (XMLStreamWriter)context.getWriter());
                XmlUtil.writeOptionalDouble((String)"fictitiousQ0", (double)fictQ0, (double)0.0, (XMLStreamWriter)context.getWriter());
            }
        });
        context.getWriter().writeEndElement();
    }

    private static void writeCalculatedBus(Bus bus, Set<Integer> nodes, NetworkXmlWriterContext context) {
        try {
            boolean writeProperties;
            boolean bl = writeProperties = context.getVersion().compareTo(IidmXmlVersion.V_1_11) >= 0 && bus.hasProperty();
            if (writeProperties) {
                context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), "bus");
            } else {
                context.getWriter().writeEmptyElement(context.getVersion().getNamespaceURI(context.isValid()), "bus");
            }
            XmlUtil.writeDouble((String)"v", (double)bus.getV(), (XMLStreamWriter)context.getWriter());
            XmlUtil.writeDouble((String)"angle", (double)bus.getAngle(), (XMLStreamWriter)context.getWriter());
            context.getWriter().writeAttribute("nodes", StringUtils.join((Object[])nodes.toArray(), (char)','));
            if (writeProperties) {
                PropertiesXml.write(bus, context);
                context.getWriter().writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private void writeNodeBreakerTopologyInternalConnections(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (VoltageLevel.NodeBreakerView.InternalConnection ic : IidmXmlUtil.sortedInternalConnections(vl.getNodeBreakerView().getInternalConnections(), context.getOptions())) {
            NodeBreakerViewInternalConnectionXml.INSTANCE.write(ic.getNode1(), ic.getNode2(), context);
        }
    }

    private void writeBusBreakerTopology(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), BUS_BREAKER_TOPOLOGY_ELEMENT_NAME);
        for (Bus b : IidmXmlUtil.sorted(vl.getBusBreakerView().getBuses(), context.getOptions())) {
            if (!context.getFilter().test(b)) continue;
            BusXml.INSTANCE.write(b, null, context);
        }
        for (Switch sw : IidmXmlUtil.sorted(vl.getBusBreakerView().getSwitches(), context.getOptions())) {
            Bus b1 = vl.getBusBreakerView().getBus1(sw.getId());
            Bus b2 = vl.getBusBreakerView().getBus2(sw.getId());
            if (!context.getFilter().test(b1) || !context.getFilter().test(b2)) continue;
            BusBreakerViewSwitchXml.INSTANCE.write(sw, vl, context);
        }
        context.getWriter().writeEndElement();
    }

    private void writeBusBranchTopology(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeStartElement(context.getVersion().getNamespaceURI(context.isValid()), BUS_BREAKER_TOPOLOGY_ELEMENT_NAME);
        for (Bus b : IidmXmlUtil.sorted(vl.getBusView().getBuses(), context.getOptions())) {
            if (!context.getFilter().test(b)) continue;
            BusXml.INSTANCE.write(b, null, context);
        }
        context.getWriter().writeEndElement();
    }

    private void writeGenerators(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Generator g : IidmXmlUtil.sorted(vl.getGenerators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)g)) continue;
            GeneratorXml.INSTANCE.write(g, vl, context);
        }
    }

    private void writeBatteries(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Battery b : IidmXmlUtil.sorted(vl.getBatteries(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)b)) continue;
            BatteryXml.INSTANCE.write(b, vl, context);
        }
    }

    private void writeLoads(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (Load l : IidmXmlUtil.sorted(vl.getLoads(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)l)) continue;
            LoadXml.INSTANCE.write(l, vl, context);
        }
    }

    private void writeShuntCompensators(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (ShuntCompensator sc : IidmXmlUtil.sorted(vl.getShuntCompensators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)sc)) continue;
            ShuntXml.INSTANCE.write(sc, vl, context);
        }
    }

    private void writeDanglingLines(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (DanglingLine dl : IidmXmlUtil.sorted(vl.getDanglingLines(DanglingLineFilter.ALL), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)dl) || context.getVersion().compareTo(IidmXmlVersion.V_1_10) < 0 && dl.isPaired()) continue;
            DanglingLineXml.INSTANCE.write(dl, vl, context);
        }
    }

    private void writeStaticVarCompensators(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (StaticVarCompensator svc : IidmXmlUtil.sorted(vl.getStaticVarCompensators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)svc)) continue;
            StaticVarCompensatorXml.INSTANCE.write(svc, vl, context);
        }
    }

    private void writeVscConverterStations(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (VscConverterStation cs : IidmXmlUtil.sorted(vl.getVscConverterStations(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)cs)) continue;
            VscConverterStationXml.INSTANCE.write(cs, vl, context);
        }
    }

    private void writeLccConverterStations(VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        for (LccConverterStation cs : IidmXmlUtil.sorted(vl.getLccConverterStations(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)cs)) continue;
            LccConverterStationXml.INSTANCE.write(cs, vl, context);
        }
    }

    @Override
    protected VoltageLevelAdder createAdder(Container<? extends Identifiable<?>> c) {
        if (c instanceof Network) {
            Network network = (Network)c;
            return network.newVoltageLevel();
        }
        if (c instanceof Substation) {
            Substation substation = (Substation)c;
            return substation.newVoltageLevel();
        }
        throw new IllegalStateException();
    }

    @Override
    protected VoltageLevel readRootElementAttributes(VoltageLevelAdder adder, Container<? extends Identifiable<?>> c, NetworkXmlReaderContext context) {
        double nominalV = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"nominalV");
        double lowVoltageLimit = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"lowVoltageLimit");
        double highVoltageLimit = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"highVoltageLimit");
        TopologyKind topologyKind = TopologyKind.valueOf((String)context.getReader().getAttributeValue(null, "topologyKind"));
        return adder.setNominalV(nominalV).setLowVoltageLimit(lowVoltageLimit).setHighVoltageLimit(highVoltageLimit).setTopologyKind(topologyKind).add();
    }

    @Override
    protected void readSubElements(VoltageLevel vl, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "nodeBreakerTopology": {
                    this.readNodeBreakerTopology(vl, context);
                    break;
                }
                case "busBreakerTopology": {
                    this.readBusBreakerTopology(vl, context);
                    break;
                }
                case "generator": {
                    GeneratorXml.INSTANCE.read(vl, context);
                    break;
                }
                case "battery": {
                    BatteryXml.INSTANCE.read(vl, context);
                    break;
                }
                case "load": {
                    LoadXml.INSTANCE.read(vl, context);
                    break;
                }
                case "shunt": {
                    ShuntXml.INSTANCE.read(vl, context);
                    break;
                }
                case "danglingLine": {
                    DanglingLineXml.INSTANCE.read(vl, context);
                    break;
                }
                case "staticVarCompensator": {
                    StaticVarCompensatorXml.INSTANCE.read(vl, context);
                    break;
                }
                case "vscConverterStation": {
                    VscConverterStationXml.INSTANCE.read(vl, context);
                    break;
                }
                case "lccConverterStation": {
                    LccConverterStationXml.INSTANCE.read(vl, context);
                    break;
                }
                default: {
                    super.readSubElements(vl, context);
                }
            }
        });
    }

    private void readNodeBreakerTopology(VoltageLevel vl, NetworkXmlReaderContext context) throws XMLStreamException {
        IidmXmlUtil.runUntilMaximumVersion(IidmXmlVersion.V_1_1, context, () -> LOGGER.trace("attribute nodeBreakerTopology.nodeCount is ignored."));
        XmlUtil.readUntilEndElement((String)NODE_BREAKER_TOPOLOGY_ELEMENT_NAME, (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "busbarSection": {
                    BusbarSectionXml.INSTANCE.read(vl, context);
                    break;
                }
                case "switch": {
                    NodeBreakerViewSwitchXml.INSTANCE.read(vl, context);
                    break;
                }
                case "internalConnection": {
                    NodeBreakerViewInternalConnectionXml.INSTANCE.read(vl, context);
                    break;
                }
                case "bus": {
                    this.readCalculatedBus(vl, context);
                    break;
                }
                case "inj": {
                    this.readFictitiousInjection(vl, context);
                    break;
                }
                default: {
                    throw new IllegalStateException(UNEXPECTED_ELEMENT + context.getReader().getLocalName());
                }
            }
        });
    }

    private void readCalculatedBus(VoltageLevel vl, NetworkXmlReaderContext context) throws XMLStreamException {
        IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "bus", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_1, context);
        double v = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"v");
        double angle = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"angle");
        String nodesString = context.getReader().getAttributeValue(null, "nodes");
        HashMap properties = new HashMap();
        XmlUtil.readUntilEndElement((String)"bus", (XMLStreamReader)context.getReader(), () -> {
            if (!context.getReader().getLocalName().equals("property")) {
                throw new IllegalStateException(UNEXPECTED_ELEMENT + context.getReader().getLocalName());
            }
            String name = context.getReader().getAttributeValue(null, "name");
            String value = context.getReader().getAttributeValue(null, "value");
            properties.put(name, value);
        });
        context.getEndTasks().add(() -> {
            for (String str : nodesString.split(",")) {
                Bus b;
                int node = Integer.parseInt(str);
                Terminal terminal = vl.getNodeBreakerView().getTerminal(node);
                if (terminal == null || (b = terminal.getBusView().getBus()) == null) continue;
                b.setV(v).setAngle(angle);
                properties.forEach((arg_0, arg_1) -> ((Bus)b).setProperty(arg_0, arg_1));
                break;
            }
        });
    }

    private void readFictitiousInjection(VoltageLevel vl, NetworkXmlReaderContext context) {
        IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "inj", IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_8, context);
        int node = XmlUtil.readIntAttribute((XMLStreamReader)context.getReader(), (String)"node");
        double p0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fictitiousP0");
        double q0 = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fictitiousQ0");
        if (!Double.isNaN(p0)) {
            vl.getNodeBreakerView().setFictitiousP0(node, p0);
        }
        if (!Double.isNaN(q0)) {
            vl.getNodeBreakerView().setFictitiousQ0(node, q0);
        }
    }

    private void readBusBreakerTopology(VoltageLevel vl, NetworkXmlReaderContext context) throws XMLStreamException {
        XmlUtil.readUntilEndElement((String)BUS_BREAKER_TOPOLOGY_ELEMENT_NAME, (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "bus": {
                    BusXml.INSTANCE.read(vl, context);
                    break;
                }
                case "switch": {
                    BusBreakerViewSwitchXml.INSTANCE.read(vl, context);
                    break;
                }
                default: {
                    throw new IllegalStateException(UNEXPECTED_ELEMENT + context.getReader().getLocalName());
                }
            }
        });
    }
}

