/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import com.powsybl.iidm.xml.AbstractSimpleIdentifiableXml;
import com.powsybl.iidm.xml.ConnectableXmlUtil;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.ReactiveLimitsXml;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

class VscConverterStationXml
extends AbstractSimpleIdentifiableXml<VscConverterStation, VscConverterStationAdder, VoltageLevel> {
    static final VscConverterStationXml INSTANCE = new VscConverterStationXml();
    static final String ROOT_ELEMENT_NAME = "vscConverterStation";
    private static final String REGULATING_TERMINAL = "regulatingTerminal";

    VscConverterStationXml() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected boolean hasSubElements(VscConverterStation cs) {
        return true;
    }

    @Override
    protected void writeRootElementAttributes(VscConverterStation cs, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute("voltageRegulatorOn", Boolean.toString(cs.isVoltageRegulatorOn()));
        XmlUtil.writeFloat((String)"lossFactor", (float)cs.getLossFactor(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"voltageSetpoint", (double)cs.getVoltageSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"reactivePowerSetpoint", (double)cs.getReactivePowerSetpoint(), (XMLStreamWriter)context.getWriter());
        ConnectableXmlUtil.writeNodeOrBus(null, cs.getTerminal(), context);
        ConnectableXmlUtil.writePQ(null, cs.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(VscConverterStation cs, VoltageLevel vl, NetworkXmlWriterContext context) throws XMLStreamException {
        ReactiveLimitsXml.INSTANCE.write((ReactiveLimitsHolder)cs, context);
        IidmXmlUtil.assertMinimumVersionAndRunIfNotDefault(!Objects.equals(cs, cs.getRegulatingTerminal().getConnectable()), ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmXmlUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmXmlVersion.V_1_6, context, () -> TerminalRefXml.writeTerminalRef(cs.getRegulatingTerminal(), context, REGULATING_TERMINAL));
    }

    @Override
    protected VscConverterStationAdder createAdder(VoltageLevel vl) {
        return vl.newVscConverterStation();
    }

    @Override
    protected VscConverterStation readRootElementAttributes(VscConverterStationAdder adder, VoltageLevel voltageLevel, NetworkXmlReaderContext context) {
        String voltageRegulatorOn = context.getReader().getAttributeValue(null, "voltageRegulatorOn");
        float lossFactor = XmlUtil.readFloatAttribute((XMLStreamReader)context.getReader(), (String)"lossFactor");
        double voltageSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"voltageSetpoint");
        double reactivePowerSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"reactivePowerSetpoint");
        ConnectableXmlUtil.readNodeOrBus(adder, context);
        ((VscConverterStationAdder)adder.setLossFactor(lossFactor)).setVoltageSetpoint(voltageSetpoint).setReactivePowerSetpoint(reactivePowerSetpoint).setVoltageRegulatorOn(Boolean.parseBoolean(voltageRegulatorOn));
        VscConverterStation cs = adder.add();
        ConnectableXmlUtil.readPQ(null, cs.getTerminal(), context.getReader());
        return cs;
    }

    @Override
    protected void readSubElements(VscConverterStation cs, NetworkXmlReaderContext context) throws XMLStreamException {
        this.readUntilEndRootElement(context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "reactiveCapabilityCurve": 
                case "minMaxReactiveLimits": {
                    ReactiveLimitsXml.INSTANCE.read((ReactiveLimitsHolder)cs, context);
                    break;
                }
                case "regulatingTerminal": {
                    IidmXmlUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, REGULATING_TERMINAL, IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_6, context);
                    String id = context.getAnonymizer().deanonymizeString(context.getReader().getAttributeValue(null, "id"));
                    String side = context.getReader().getAttributeValue(null, "side");
                    context.getEndTasks().add(() -> cs.setRegulatingTerminal(TerminalRefXml.resolve(id, side, cs.getNetwork())));
                    break;
                }
                default: {
                    super.readSubElements(cs, context);
                }
            }
        });
    }
}

