/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.google.auto.service.AutoService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.iidm.network.Exporter;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.xml.ExportOptions;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXml;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Exporter.class})
public class XMLExporter
implements Exporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLExporter.class);
    private static final Supplier<ExtensionProviders<ExtensionXmlSerializer>> EXTENSIONS_SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionXmlSerializer.class, (String)"network"));
    public static final String INDENT = "iidm.export.xml.indent";
    public static final String WITH_BRANCH_STATE_VARIABLES = "iidm.export.xml.with-branch-state-variables";
    public static final String ONLY_MAIN_CC = "iidm.export.xml.only-main-cc";
    public static final String ANONYMISED = "iidm.export.xml.anonymised";
    public static final String IIDM_VERSION_INCOMPATIBILITY_BEHAVIOR = "iidm.export.xml.iidm-version-incompatibility-behavior";
    public static final String TOPOLOGY_LEVEL = "iidm.export.xml.topology-level";
    public static final String THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND = "iidm.export.xml.throw-exception-if-extension-not-found";
    public static final String EXTENSIONS_LIST = "iidm.export.xml.extensions";
    public static final String SORTED = "iidm.export.xml.sorted";
    public static final String VERSION = "iidm.export.xml.version";
    private static final Parameter INDENT_PARAMETER = new Parameter("iidm.export.xml.indent", ParameterType.BOOLEAN, "Indent export output file", (Object)Boolean.TRUE);
    private static final Parameter WITH_BRANCH_STATE_VARIABLES_PARAMETER = new Parameter("iidm.export.xml.with-branch-state-variables", ParameterType.BOOLEAN, "Export network with branch state variables", (Object)Boolean.TRUE);
    private static final Parameter ONLY_MAIN_CC_PARAMETER = new Parameter("iidm.export.xml.only-main-cc", ParameterType.BOOLEAN, "Export only main CC", (Object)Boolean.FALSE);
    private static final Parameter ANONYMISED_PARAMETER = new Parameter("iidm.export.xml.anonymised", ParameterType.BOOLEAN, "Anonymise exported network", (Object)Boolean.FALSE);
    private static final Parameter IIDM_VERSION_INCOMPATIBILITY_BEHAVIOR_PARAMETER = new Parameter("iidm.export.xml.iidm-version-incompatibility-behavior", ParameterType.STRING, "Behavior when there is an IIDM version incompatibility", (Object)"THROW_EXCEPTION", List.of("LOG_ERROR", "THROW_EXCEPTION"));
    private static final Parameter TOPOLOGY_LEVEL_PARAMETER = new Parameter("iidm.export.xml.topology-level", ParameterType.STRING, "Export network in this topology level", (Object)TopologyLevel.NODE_BREAKER.name(), Arrays.stream(TopologyLevel.values()).map(Enum::name).collect(Collectors.toList()));
    private static final Parameter THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER = new Parameter("iidm.export.xml.throw-exception-if-extension-not-found", ParameterType.BOOLEAN, "Throw exception if extension not found", (Object)Boolean.FALSE);
    private static final Parameter EXTENSIONS_LIST_PARAMETER = new Parameter("iidm.export.xml.extensions", ParameterType.STRING_LIST, "The list of exported extensions", null, ((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).getProviders().stream().map(ExtensionProvider::getExtensionName).collect(Collectors.toList()));
    private static final Parameter SORTED_PARAMETER = new Parameter("iidm.export.xml.sorted", ParameterType.BOOLEAN, "Sort export output file", (Object)Boolean.FALSE);
    private static final Parameter VERSION_PARAMETER = new Parameter("iidm.export.xml.version", ParameterType.STRING, "IIDM-XML version in which files will be generated", (Object)IidmXmlConstants.CURRENT_IIDM_XML_VERSION.toString("."), Arrays.stream(IidmXmlVersion.values()).map(v -> v.toString(".")).collect(Collectors.toList()));
    private static final List<Parameter> STATIC_PARAMETERS = List.of(INDENT_PARAMETER, WITH_BRANCH_STATE_VARIABLES_PARAMETER, ONLY_MAIN_CC_PARAMETER, ANONYMISED_PARAMETER, IIDM_VERSION_INCOMPATIBILITY_BEHAVIOR_PARAMETER, TOPOLOGY_LEVEL_PARAMETER, THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, EXTENSIONS_LIST_PARAMETER, SORTED_PARAMETER, VERSION_PARAMETER);
    private final ParameterDefaultValueConfig defaultValueConfig;

    public XMLExporter() {
        this(PlatformConfig.defaultConfig());
    }

    public XMLExporter(PlatformConfig platformConfig) {
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
    }

    public String getFormat() {
        return "XIIDM";
    }

    public String getComment() {
        return "IIDM XML v" + IidmXmlConstants.CURRENT_IIDM_XML_VERSION.toString(".") + " exporter";
    }

    public void export(Network network, Properties parameters, DataSource dataSource) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        ExportOptions options = this.createExportOptions(parameters);
        try {
            long startTime = System.currentTimeMillis();
            NetworkXml.write(network, options, dataSource, "xiidm");
            LOGGER.debug("XIIDM export done in {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<Parameter> getParameters() {
        return STATIC_PARAMETERS;
    }

    private void addExtensionsVersions(Properties parameters, ExportOptions options) {
        ((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).getProviders().forEach(extensionXmlSerializer -> {
            String extensionName = extensionXmlSerializer.getExtensionName();
            Parameter parameter = new Parameter("iidm.export.xml." + extensionName + ".version", ParameterType.STRING, "Version of " + extensionName, null);
            String extensionVersion = Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)parameter, (ParameterDefaultValueConfig)this.defaultValueConfig);
            if (extensionVersion != null) {
                if (options.getExtensions().map(extensions -> extensions.contains(extensionName)).orElse(true).booleanValue()) {
                    options.addExtensionVersion(extensionName, extensionVersion);
                } else {
                    LOGGER.warn(String.format("Version of %s is ignored since %s is not in the extensions list to export.", extensionName, extensionName));
                }
            }
        });
    }

    private ExportOptions createExportOptions(Properties parameters) {
        ExportOptions options = ((ExportOptions)new ExportOptions().setIndent(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)INDENT_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setWithBranchSV(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)WITH_BRANCH_STATE_VARIABLES_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setOnlyMainCc(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)ONLY_MAIN_CC_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setAnonymized(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)ANONYMISED_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setIidmVersionIncompatibilityBehavior(ExportOptions.IidmVersionIncompatibilityBehavior.valueOf(Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)IIDM_VERSION_INCOMPATIBILITY_BEHAVIOR_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig))).setTopologyLevel(TopologyLevel.valueOf((String)Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)TOPOLOGY_LEVEL_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig))).setThrowExceptionIfExtensionNotFound(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setExtensions((Set)(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig) != null ? new HashSet(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)) : null))).setSorted(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)SORTED_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setVersion(Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)VERSION_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
        this.addExtensionsVersions(parameters, options);
        return options;
    }
}

