/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml;

import com.google.auto.service.AutoService;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.ImportOptions;
import com.powsybl.iidm.xml.NetworkXml;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Importer.class})
public class XMLImporter
implements Importer {
    private static final Supplier<ExtensionProviders<ExtensionXmlSerializer>> EXTENSIONS_SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionXmlSerializer.class, (String)"network"));
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLImporter.class);
    private static final String[] EXTENSIONS = new String[]{"xiidm", "iidm", "xml", "iidm.xml"};
    private static final Supplier<XMLInputFactory> XML_INPUT_FACTORY_SUPPLIER = Suppliers.memoize(XMLInputFactory::newInstance);
    public static final String THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND = "iidm.import.xml.throw-exception-if-extension-not-found";
    public static final String EXTENSIONS_LIST = "iidm.import.xml.extensions";
    private static final Parameter THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER = new Parameter("iidm.import.xml.throw-exception-if-extension-not-found", ParameterType.BOOLEAN, "Throw exception if extension not found", (Object)Boolean.FALSE).addAdditionalNames(new String[]{"throwExceptionIfExtensionNotFound"});
    private static final Parameter EXTENSIONS_LIST_PARAMETER = new Parameter("iidm.import.xml.extensions", ParameterType.STRING_LIST, "The list of extension files ", null, ((ExtensionProviders)EXTENSIONS_SUPPLIER.get()).getProviders().stream().map(ExtensionProvider::getExtensionName).collect(Collectors.toList()));
    private final ParameterDefaultValueConfig defaultValueConfig;
    static final String SUFFIX_MAPPING = "_mapping";

    public XMLImporter() {
        this(PlatformConfig.defaultConfig());
    }

    public XMLImporter(PlatformConfig platformConfig) {
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
    }

    public String getFormat() {
        return "XIIDM";
    }

    public List<Parameter> getParameters() {
        return ImmutableList.of((Object)THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, (Object)EXTENSIONS_LIST_PARAMETER);
    }

    public String getComment() {
        return "IIDM XML v " + IidmXmlConstants.CURRENT_IIDM_XML_VERSION.toString(".") + " importer";
    }

    private String findExtension(ReadOnlyDataSource dataSource) throws IOException {
        for (String ext : EXTENSIONS) {
            if (!dataSource.exists(null, ext)) continue;
            return ext;
        }
        return null;
    }

    public boolean exists(ReadOnlyDataSource dataSource) {
        try {
            String ext = this.findExtension(dataSource);
            return this.exists(dataSource, ext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        try {
            if (ext == null) return false;
            try (InputStream is = dataSource.newInputStream(null, ext);){
                XMLStreamReader xmlsr = ((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()).createXMLStreamReader(is);
                try {
                    int eventType;
                    do {
                        if (!xmlsr.hasNext()) return false;
                    } while ((eventType = xmlsr.next()) != 1);
                    String name = xmlsr.getLocalName();
                    String ns = xmlsr.getNamespaceURI();
                    boolean bl = "network".equals(name) && (Stream.of(IidmXmlVersion.values()).anyMatch(v -> v.getNamespaceURI().equals(ns)) || Stream.of(IidmXmlVersion.values()).filter(v -> v.compareTo(IidmXmlVersion.V_1_7) >= 0).anyMatch(v -> v.getNamespaceURI(false).equals(ns)));
                    return bl;
                }
                finally {
                    try {
                        xmlsr.close();
                        XmlUtil.gcXmlInputFactory((XMLInputFactory)((XMLInputFactory)XML_INPUT_FACTORY_SUPPLIER.get()));
                    }
                    catch (XMLStreamException e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
        block28: {
            try {
                OutputStream os;
                String ext = this.findExtension(fromDataSource);
                if (!this.exists(fromDataSource, ext)) {
                    throw new PowsyblException("From data source is not importable");
                }
                try (InputStream is = fromDataSource.newInputStream(null, ext);){
                    os = toDataSource.newOutputStream(null, ext, false);
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                if (!fromDataSource.exists(SUFFIX_MAPPING, "csv")) break block28;
                is = fromDataSource.newInputStream(SUFFIX_MAPPING, "csv");
                try {
                    os = toDataSource.newOutputStream(SUFFIX_MAPPING, "csv", false);
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters) {
        Network network;
        Objects.requireNonNull(dataSource);
        ImportOptions options = this.createImportOptions(parameters);
        long startTime = System.currentTimeMillis();
        try {
            String ext = this.findExtension(dataSource);
            if (ext == null) {
                throw new PowsyblException("File " + dataSource.getBaseName() + "." + Joiner.on((String)"|").join((Object[])EXTENSIONS) + " not found");
            }
            network = NetworkXml.read(dataSource, networkFactory, options, ext);
            LOGGER.debug("XIIDM import done in {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (IOException e) {
            throw new PowsyblException((Throwable)e);
        }
        return network;
    }

    private ImportOptions createImportOptions(Properties parameters) {
        return new ImportOptions().setThrowExceptionIfExtensionNotFound(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setExtensions((Set)(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig) != null ? new HashSet(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)) : null));
    }
}

