/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.iidm.xml.IidmXmlConstants;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public abstract class AbstractVersionableNetworkExtensionXmlSerializer<T extends Extendable, E extends Extension<T>>
implements ExtensionXmlSerializer<T, E> {
    private static final String INCOMPATIBILITY_NETWORK_VERSION_MESSAGE = "IIDM-XML version of network (";
    private final String extensionName;
    private final Class<? super E> extensionClass;
    private final boolean subElements;
    private final String namespacePrefix;
    private final Map<IidmXmlVersion, ImmutableSortedSet<String>> extensionVersions = new EnumMap<IidmXmlVersion, ImmutableSortedSet<String>>(IidmXmlVersion.class);
    private final Map<String, String> namespaceUris = new HashMap<String, String>();

    protected AbstractVersionableNetworkExtensionXmlSerializer(String extensionName, Class<? super E> extensionClass, boolean subElements, String namespacePrefix, Map<IidmXmlVersion, ImmutableSortedSet<String>> extensionVersions, Map<String, String> namespaceUris) {
        this.extensionName = Objects.requireNonNull(extensionName);
        this.extensionClass = Objects.requireNonNull(extensionClass);
        this.subElements = subElements;
        this.namespacePrefix = Objects.requireNonNull(namespacePrefix);
        this.extensionVersions.putAll(Objects.requireNonNull(extensionVersions));
        this.namespaceUris.putAll(Objects.requireNonNull(namespaceUris));
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getCategoryName() {
        return "network";
    }

    public Class<? super E> getExtensionClass() {
        return this.extensionClass;
    }

    public boolean hasSubElements() {
        return this.subElements;
    }

    public String getNamespaceUri() {
        return this.getNamespaceUri(this.getVersion());
    }

    public String getNamespaceUri(String extensionVersion) {
        return Optional.ofNullable(this.namespaceUris.get(extensionVersion)).orElseThrow(() -> new PowsyblException("Namespace URI null for " + this.getExtensionName() + " extension's version " + extensionVersion));
    }

    public String getVersion() {
        return this.getVersion(IidmXmlConstants.CURRENT_IIDM_XML_VERSION);
    }

    public boolean versionExists(IidmXmlVersion networkVersion) {
        return this.extensionVersions.containsKey((Object)networkVersion);
    }

    public String getVersion(IidmXmlVersion networkVersion) {
        return (String)this.extensionVersions.get((Object)networkVersion).last();
    }

    public Set<String> getVersions() {
        return this.namespaceUris.keySet();
    }

    protected void checkReadingCompatibility(NetworkXmlReaderContext networkContext) {
        IidmXmlVersion version = networkContext.getVersion();
        this.checkCompatibilityNetworkVersion(version);
        if (this.extensionVersions.get((Object)version).stream().noneMatch(v -> networkContext.containsExtensionNamespaceUri(this.getNamespaceUri((String)v)))) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not compatible with the " + this.extensionName + " extension's namespace URI.");
        }
    }

    public void checkWritingCompatibility(String extensionVersion, IidmXmlVersion version) {
        this.checkExtensionVersionSupported(extensionVersion);
        this.checkCompatibilityNetworkVersion(version);
        if (!this.extensionVersions.get((Object)version).contains((Object)extensionVersion)) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not compatible with the version " + extensionVersion + " of the " + this.extensionName + " extension.");
        }
    }

    private void checkCompatibilityNetworkVersion(IidmXmlVersion version) {
        if (!this.extensionVersions.containsKey((Object)version)) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not supported by the " + this.getExtensionName() + " extension's XML serializer.");
        }
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void checkExtensionVersionSupported(String extensionVersion) {
        if (!this.namespaceUris.containsKey(extensionVersion)) {
            throw new PowsyblException("The version " + extensionVersion + " of the " + this.extensionName + " extension is not supported.");
        }
    }
}

