/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.extensions.AbstractVersionableNetworkExtensionXmlSerializer;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class ActivePowerControlXmlSerializer<T extends Injection<T>>
extends AbstractVersionableNetworkExtensionXmlSerializer<T, ActivePowerControl<T>> {
    public ActivePowerControlXmlSerializer() {
        super("activePowerControl", ActivePowerControl.class, false, "apc", (Map<IidmXmlVersion, ImmutableSortedSet<String>>)new ImmutableMap.Builder().put((Object)IidmXmlVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).put((Object)IidmXmlVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.1"))).build(), (Map<String, String>)new ImmutableMap.Builder().put((Object)"1.0", (Object)"http://www.itesla_project.eu/schema/iidm/ext/active_power_control/1_0").put((Object)"1.1", (Object)"http://www.powsybl.org/schema/iidm/ext/active_power_control/1_1").build());
    }

    public void write(ActivePowerControl<T> activePowerControl, XmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute("participate", Boolean.toString(activePowerControl.isParticipate()));
        XmlUtil.writeDouble((String)"droop", (double)activePowerControl.getDroop(), (XMLStreamWriter)context.getWriter());
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        String extVersionStr = networkContext.getExtensionVersion("position").orElseGet(() -> this.getVersion(networkContext.getVersion()));
        if ("1.1".compareTo(extVersionStr) <= 0) {
            XmlUtil.writeDouble((String)"participationFactor", (double)activePowerControl.getParticipationFactor(), (XMLStreamWriter)context.getWriter());
        }
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_1.xsd"), this.getClass().getResourceAsStream("/xsd/activePowerControl_V1_0.xsd"));
    }

    public ActivePowerControl<T> read(T identifiable, XmlReaderContext context) {
        boolean participate = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"participate");
        double droop = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"droop");
        double participationFactor = Double.NaN;
        NetworkXmlReaderContext networkContext = (NetworkXmlReaderContext)context;
        String extVersionStr = networkContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new);
        if ("1.1".compareTo(extVersionStr) <= 0) {
            participationFactor = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"participationFactor", (double)0.0);
        }
        ActivePowerControlAdder activePowerControlAdder = (ActivePowerControlAdder)identifiable.newExtension(ActivePowerControlAdder.class);
        return (ActivePowerControl)activePowerControlAdder.withParticipate(participate).withDroop(droop).withParticipationFactor(participationFactor).add();
    }
}

