/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.extensions.BranchObservability;
import com.powsybl.iidm.network.extensions.BranchObservabilityAdder;
import com.powsybl.iidm.network.extensions.ObservabilityQuality;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class BranchObservabilityXmlSerializer<T extends Branch<T>>
extends AbstractExtensionXmlSerializer<T, BranchObservability<T>> {
    private static final String QUALITY_P = "qualityP";
    private static final String QUALITY_Q = "qualityQ";
    private static final String SIDE = "side";
    private static final String STANDARD_DEVIATION = "standardDeviation";
    private static final String REDUNDANT = "redundant";

    public BranchObservabilityXmlSerializer() {
        super("branchObservability", "network", BranchObservability.class, true, "branchObservability.xsd", "http://www.itesla_project.eu/schema/iidm/ext/branch_observability/1_0", "bo");
    }

    public void write(BranchObservability<T> branchObservability, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeOptionalBoolean((String)"observable", (boolean)branchObservability.isObservable(), (boolean)false, (XMLStreamWriter)context.getWriter());
        this.writeOptionalQuality(context, branchObservability.getQualityP1(), QUALITY_P, Branch.Side.ONE);
        this.writeOptionalQuality(context, branchObservability.getQualityP2(), QUALITY_P, Branch.Side.TWO);
        this.writeOptionalQuality(context, branchObservability.getQualityQ1(), QUALITY_Q, Branch.Side.ONE);
        this.writeOptionalQuality(context, branchObservability.getQualityQ2(), QUALITY_Q, Branch.Side.TWO);
    }

    private void writeOptionalQuality(XmlWriterContext context, ObservabilityQuality<T> quality, String type, Branch.Side side) throws XMLStreamException {
        if (quality == null) {
            return;
        }
        context.getWriter().writeEmptyElement(this.getNamespaceUri(), type);
        context.getWriter().writeAttribute(SIDE, side.name());
        XmlUtil.writeDouble((String)STANDARD_DEVIATION, (double)quality.getStandardDeviation(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalBoolean((String)REDUNDANT, (Optional)quality.isRedundant(), (XMLStreamWriter)context.getWriter());
    }

    public BranchObservability<T> read(T identifiable, XmlReaderContext context) throws XMLStreamException {
        boolean observable = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)"observable", (boolean)false);
        BranchObservabilityAdder adder = ((BranchObservabilityAdder)identifiable.newExtension(BranchObservabilityAdder.class)).withObservable(observable);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "qualityP": {
                    Branch.Side side = Branch.Side.valueOf((String)context.getReader().getAttributeValue(null, SIDE));
                    double standardDeviation = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)STANDARD_DEVIATION);
                    String redundant = context.getReader().getAttributeValue(null, REDUNDANT);
                    this.readQualityP(standardDeviation, redundant, side, adder);
                    break;
                }
                case "qualityQ": {
                    Branch.Side side = Branch.Side.valueOf((String)context.getReader().getAttributeValue(null, SIDE));
                    double standardDeviation = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)STANDARD_DEVIATION);
                    String redundant = context.getReader().getAttributeValue(null, REDUNDANT);
                    this.readQualityQ(standardDeviation, redundant, side, adder);
                    break;
                }
                default: {
                    throw new PowsyblException("Unexpected element: " + context.getReader().getLocalName());
                }
            }
        });
        return (BranchObservability)adder.add();
    }

    private void readQualityP(double standardDeviation, String redundant, Branch.Side side, BranchObservabilityAdder<T> adder) {
        if (side == Branch.Side.ONE) {
            adder.withStandardDeviationP1(standardDeviation);
            if (redundant != null) {
                adder.withRedundantP1(Boolean.valueOf(Boolean.parseBoolean(redundant)));
            }
        } else if (side == Branch.Side.TWO) {
            adder.withStandardDeviationP2(standardDeviation);
            if (redundant != null) {
                adder.withRedundantP2(Boolean.valueOf(Boolean.parseBoolean(redundant)));
            }
        }
    }

    private void readQualityQ(double standardDeviation, String redundant, Branch.Side side, BranchObservabilityAdder<T> adder) {
        if (side == Branch.Side.ONE) {
            adder.withStandardDeviationQ1(standardDeviation);
            if (redundant != null) {
                adder.withRedundantQ1(Boolean.valueOf(Boolean.parseBoolean(redundant)));
            }
        } else if (side == Branch.Side.TWO) {
            adder.withStandardDeviationQ2(standardDeviation);
            if (redundant != null) {
                adder.withRedundantQ2(Boolean.valueOf(Boolean.parseBoolean(redundant)));
            }
        }
    }
}

