/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.extensions.AbstractVersionableNetworkExtensionXmlSerializer;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class ConnectablePositionXmlSerializer<C extends Connectable<C>>
extends AbstractVersionableNetworkExtensionXmlSerializer<C, ConnectablePosition<C>> {
    private static final String V_1_0 = "1.0";
    private static final String V_1_1 = "1.1";

    public ConnectablePositionXmlSerializer() {
        super("position", ConnectablePosition.class, true, "cp", (Map<IidmXmlVersion, ImmutableSortedSet<String>>)ImmutableMap.builder().put((Object)IidmXmlVersion.V_1_0, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_1, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_2, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).build(), (Map<String, String>)ImmutableMap.builder().put((Object)V_1_0, (Object)"http://www.itesla_project.eu/schema/iidm/ext/connectable_position/1_0").put((Object)V_1_1, (Object)"http://www.powsybl.org/schema/iidm/ext/connectable_position/1_1").build());
    }

    private void writePosition(String connectableId, ConnectablePosition.Feeder feeder, Integer i, NetworkXmlWriterContext context) throws XMLStreamException {
        String extVersionStr;
        context.getWriter().writeEmptyElement(context.getExtensionVersion("position").map(this::getNamespaceUri).orElseGet(this::getNamespaceUri), "feeder" + (Serializable)(i != null ? i : ""));
        switch (extVersionStr = context.getExtensionVersion("position").orElseGet(() -> this.getVersion(context.getVersion()))) {
            case "1.0": {
                context.getWriter().writeAttribute("name", feeder.getName().orElse(connectableId));
                break;
            }
            case "1.1": {
                feeder.getName().ifPresent(name -> {
                    try {
                        context.getWriter().writeAttribute("name", (String)name);
                    }
                    catch (XMLStreamException e) {
                        throw new UncheckedXmlStreamException(e);
                    }
                });
                break;
            }
            default: {
                throw new PowsyblException("Unsupported version (" + extVersionStr + ") for position");
            }
        }
        Optional oOrder = feeder.getOrder();
        if (oOrder.isPresent()) {
            XmlUtil.writeInt((String)"order", (int)((Integer)oOrder.get()), (XMLStreamWriter)context.getWriter());
        }
        context.getWriter().writeAttribute("direction", feeder.getDirection().name());
    }

    public void write(ConnectablePosition<C> connectablePosition, XmlWriterContext context) throws XMLStreamException {
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        String connectableId = ((Connectable)connectablePosition.getExtendable()).getId();
        if (connectablePosition.getFeeder() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder(), null, networkContext);
        }
        if (connectablePosition.getFeeder1() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder1(), 1, networkContext);
        }
        if (connectablePosition.getFeeder2() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder2(), 2, networkContext);
        }
        if (connectablePosition.getFeeder3() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder3(), 3, networkContext);
        }
    }

    private void readPosition(XmlReaderContext context, ConnectablePositionAdder.FeederAdder<C> adder) {
        String name = context.getReader().getAttributeValue(null, "name");
        Optional.ofNullable(XmlUtil.readOptionalIntegerAttribute((XMLStreamReader)context.getReader(), (String)"order")).ifPresent(arg_0 -> adder.withOrder(arg_0));
        ConnectablePosition.Direction direction = ConnectablePosition.Direction.valueOf((String)context.getReader().getAttributeValue(null, "direction"));
        if (name != null) {
            adder.withName(name);
        } else {
            NetworkXmlReaderContext networkXmlReaderContext = (NetworkXmlReaderContext)context;
            String extensionVersionStr = networkXmlReaderContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new);
            if (V_1_1.compareTo(extensionVersionStr) > 0) {
                throw new PowsyblException("Feeder name is mandatory for version < 1.1");
            }
        }
        adder.withDirection(direction).add();
    }

    public ConnectablePosition<C> read(C connectable, XmlReaderContext context) throws XMLStreamException {
        ConnectablePositionAdder adder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "feeder": {
                    this.readPosition(context, adder.newFeeder());
                    break;
                }
                case "feeder1": {
                    this.readPosition(context, adder.newFeeder1());
                    break;
                }
                case "feeder2": {
                    this.readPosition(context, adder.newFeeder2());
                    break;
                }
                case "feeder3": {
                    this.readPosition(context, adder.newFeeder3());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        });
        return (ConnectablePosition)adder.add();
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_1.xsd"), this.getClass().getResourceAsStream("/xsd/connectablePosition_V1_0.xsd"));
    }
}

