/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.DiscreteMeasurement;
import com.powsybl.iidm.network.extensions.DiscreteMeasurementAdder;
import com.powsybl.iidm.network.extensions.DiscreteMeasurements;
import com.powsybl.iidm.network.extensions.DiscreteMeasurementsAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class DiscreteMeasurementsXmlSerializer<I extends Identifiable<I>>
extends AbstractExtensionXmlSerializer<I, DiscreteMeasurements<I>> {
    private static final String DISCRETE_MEASUREMENT = "discreteMeasurement";
    private static final String VALUE = "value";

    public DiscreteMeasurementsXmlSerializer() {
        super("discreteMeasurements", "network", DiscreteMeasurements.class, true, "discreteMeasurements.xsd", "http://www.powsybl.org/schema/iidm/ext/discrete_measurements/1_0", "dm");
    }

    public void write(DiscreteMeasurements<I> extension, XmlWriterContext context) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        for (DiscreteMeasurement discreteMeasurement : extension.getDiscreteMeasurements()) {
            boolean hasProperty;
            boolean bl = hasProperty = !discreteMeasurement.getPropertyNames().isEmpty();
            if (hasProperty) {
                writer.writeStartElement(this.getNamespaceUri(), DISCRETE_MEASUREMENT);
            } else {
                writer.writeEmptyElement(this.getNamespaceUri(), DISCRETE_MEASUREMENT);
            }
            if (discreteMeasurement.getId() != null) {
                writer.writeAttribute("id", discreteMeasurement.getId());
            }
            writer.writeAttribute("type", discreteMeasurement.getType().toString());
            if (discreteMeasurement.getTapChanger() != null) {
                writer.writeAttribute("tapChanger", discreteMeasurement.getTapChanger().toString());
            }
            writer.writeAttribute("valueType", discreteMeasurement.getValueType().toString());
            switch (discreteMeasurement.getValueType()) {
                case BOOLEAN: {
                    writer.writeAttribute(VALUE, String.valueOf(discreteMeasurement.getValueAsBoolean()));
                    break;
                }
                case INT: {
                    writer.writeAttribute(VALUE, String.valueOf(discreteMeasurement.getValueAsInt()));
                    break;
                }
                case STRING: {
                    if (discreteMeasurement.getValueAsString() == null) break;
                    writer.writeAttribute(VALUE, discreteMeasurement.getValueAsString());
                    break;
                }
                default: {
                    throw new PowsyblException("Unsupported serialization for value type: " + discreteMeasurement.getValueType());
                }
            }
            writer.writeAttribute("valid", String.valueOf(discreteMeasurement.isValid()));
            for (String name : discreteMeasurement.getPropertyNames()) {
                writer.writeEmptyElement(this.getNamespaceUri(), "property");
                writer.writeAttribute("name", name);
                writer.writeAttribute(VALUE, discreteMeasurement.getProperty(name));
            }
            if (!hasProperty) continue;
            writer.writeEndElement();
        }
    }

    public DiscreteMeasurements<I> read(I extendable, XmlReaderContext context) throws XMLStreamException {
        DiscreteMeasurementsAdder adder = (DiscreteMeasurementsAdder)extendable.newExtension(DiscreteMeasurementsAdder.class);
        DiscreteMeasurements discreteMeasurements = (DiscreteMeasurements)adder.add();
        XMLStreamReader reader = context.getReader();
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)reader, () -> {
            if (!reader.getLocalName().equals(DISCRETE_MEASUREMENT)) {
                throw new PowsyblException("Unexpected element: " + reader.getLocalName());
            }
            DiscreteMeasurementsXmlSerializer.readDiscreteMeasurement(discreteMeasurements, reader);
        });
        return discreteMeasurements;
    }

    private static <I extends Identifiable<I>> void readDiscreteMeasurement(DiscreteMeasurements<I> discreteMeasurements, XMLStreamReader reader) throws XMLStreamException {
        DiscreteMeasurementAdder adder = discreteMeasurements.newDiscreteMeasurement().setId(reader.getAttributeValue(null, "id")).setType(DiscreteMeasurement.Type.valueOf((String)reader.getAttributeValue(null, "type"))).setValid(XmlUtil.readBoolAttribute((XMLStreamReader)reader, (String)"valid"));
        String tapChanger = reader.getAttributeValue(null, "tapChanger");
        if (tapChanger != null) {
            adder.setTapChanger(DiscreteMeasurement.TapChanger.valueOf((String)tapChanger));
        }
        DiscreteMeasurement.ValueType valueType = DiscreteMeasurement.ValueType.valueOf((String)reader.getAttributeValue(null, "valueType"));
        if (reader.getAttributeValue(null, VALUE) != null) {
            switch (valueType) {
                case BOOLEAN: {
                    adder.setValue(XmlUtil.readBoolAttribute((XMLStreamReader)reader, (String)VALUE));
                    break;
                }
                case INT: {
                    adder.setValue(XmlUtil.readIntAttribute((XMLStreamReader)reader, (String)VALUE));
                    break;
                }
                case STRING: {
                    adder.setValue(reader.getAttributeValue(null, VALUE));
                    break;
                }
                default: {
                    throw new PowsyblException("Unsupported value type: " + valueType);
                }
            }
        }
        XmlUtil.readUntilEndElement((String)DISCRETE_MEASUREMENT, (XMLStreamReader)reader, () -> {
            if (!reader.getLocalName().equals("property")) {
                throw new PowsyblException("Unexpected element: " + reader.getLocalName());
            }
            adder.putProperty(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, VALUE));
        });
        adder.add();
    }

    public boolean isSerializable(DiscreteMeasurements<I> extension) {
        return !extension.getDiscreteMeasurements().isEmpty();
    }
}

