/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.GeneratorFortescue;
import com.powsybl.iidm.network.extensions.GeneratorFortescueAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class GeneratorFortescueXmlSerializer
extends AbstractExtensionXmlSerializer<Generator, GeneratorFortescue> {
    public GeneratorFortescueXmlSerializer() {
        super("generatorFortescue", "network", GeneratorFortescue.class, false, "generatorFortescue_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/generator_fortescue/1_0", "gf");
    }

    public void write(GeneratorFortescue generatorFortescue, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeOptionalDouble((String)"rz", (double)generatorFortescue.getRz(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"xz", (double)generatorFortescue.getXz(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"rn", (double)generatorFortescue.getRn(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"xn", (double)generatorFortescue.getXn(), (double)Double.NaN, (XMLStreamWriter)context.getWriter());
        context.getWriter().writeAttribute("grounded", Boolean.toString(generatorFortescue.isGrounded()));
        XmlUtil.writeOptionalDouble((String)"groundingR", (double)generatorFortescue.getGroundingR(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"groundingX", (double)generatorFortescue.getGroundingX(), (double)0.0, (XMLStreamWriter)context.getWriter());
    }

    public GeneratorFortescue read(Generator generator, XmlReaderContext context) throws XMLStreamException {
        double rz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"rz");
        double xz = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xz");
        double rn = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"rn");
        double xn = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"xn");
        boolean toGround = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"grounded");
        double groundingR = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingR", (double)0.0);
        double groundingX = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"groundingX", (double)0.0);
        return (GeneratorFortescue)((GeneratorFortescueAdder)generator.newExtension(GeneratorFortescueAdder.class)).withRz(rz).withXz(xz).withRn(rn).withXn(xn).withGrounded(toGround).withGroundingR(groundingR).withGroundingX(groundingX).add();
    }
}

