/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.GeneratorStartup;
import com.powsybl.iidm.network.extensions.GeneratorStartupAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.extensions.AbstractVersionableNetworkExtensionXmlSerializer;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class GeneratorStartupXmlSerializer
extends AbstractVersionableNetworkExtensionXmlSerializer<Generator, GeneratorStartup>
implements ExtensionXmlSerializer<Generator, GeneratorStartup> {
    private static final String ITESLA_1_0 = "1.0-itesla";
    private static final String V_1_0 = "1.0";
    private static final String V_1_1 = "1.1";

    public GeneratorStartupXmlSerializer() {
        super("startup", GeneratorStartup.class, false, "gs", (Map<IidmXmlVersion, ImmutableSortedSet<String>>)ImmutableMap.builder().put((Object)IidmXmlVersion.V_1_0, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_1, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_2, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_3, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_4, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_5, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_6, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_7, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_8, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_9, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_10, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).put((Object)IidmXmlVersion.V_1_11, (Object)ImmutableSortedSet.of((Comparable)((Object)ITESLA_1_0), (Comparable)((Object)V_1_0), (Comparable)((Object)V_1_1))).build(), (Map<String, String>)ImmutableMap.builder().put((Object)ITESLA_1_0, (Object)"http://www.itesla_project.eu/schema/iidm/ext/generator_startup/1_0").put((Object)V_1_0, (Object)"http://www.powsybl.org/schema/iidm/ext/generator_startup/1_0").put((Object)V_1_1, (Object)"http://www.powsybl.org/schema/iidm/ext/generator_startup/1_1").build());
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(this.getClass().getResourceAsStream("/xsd/generatorStartup_itesla_V1_0.xsd"), this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_0.xsd"), this.getClass().getResourceAsStream("/xsd/generatorStartup_V1_1.xsd"));
    }

    public void write(GeneratorStartup startup, XmlWriterContext context) throws XMLStreamException {
        String plannedActivePowerSetpoint;
        String extVersionStr;
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        String startupCost = switch (extVersionStr = networkContext.getExtensionVersion("startup").orElseGet(() -> this.getVersion(networkContext.getVersion()))) {
            case ITESLA_1_0, V_1_0 -> {
                plannedActivePowerSetpoint = "predefinedActivePowerSetpoint";
                yield "startUpCost";
            }
            case V_1_1 -> {
                plannedActivePowerSetpoint = "plannedActivePowerSetpoint";
                yield "startupCost";
            }
            default -> throw new PowsyblException("Unsupported startup version: " + extVersionStr);
        };
        XmlUtil.writeDouble((String)plannedActivePowerSetpoint, (double)startup.getPlannedActivePowerSetpoint(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)startupCost, (double)startup.getStartupCost(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"marginalCost", (double)startup.getMarginalCost(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"plannedOutageRate", (double)startup.getPlannedOutageRate(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"forcedOutageRate", (double)startup.getForcedOutageRate(), (XMLStreamWriter)context.getWriter());
    }

    public GeneratorStartup read(Generator generator, XmlReaderContext context) throws XMLStreamException {
        double plannedActivePowerSetpoint;
        String extensionVersionStr;
        NetworkXmlReaderContext networkXmlReaderContext = (NetworkXmlReaderContext)context;
        double startUpCost = switch (extensionVersionStr = networkXmlReaderContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new)) {
            case ITESLA_1_0, V_1_0 -> {
                plannedActivePowerSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"predefinedActivePowerSetpoint");
                yield XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"startUpCost");
            }
            case V_1_1 -> {
                plannedActivePowerSetpoint = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"plannedActivePowerSetpoint");
                yield XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"startupCost");
            }
            default -> throw new PowsyblException("Unsupported startup version: " + extensionVersionStr);
        };
        double marginalCost = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"marginalCost");
        double plannedOutageRate = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"plannedOutageRate");
        double forcedOutageRate = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"forcedOutageRate");
        return (GeneratorStartup)((GeneratorStartupAdder)generator.newExtension(GeneratorStartupAdder.class)).withPlannedActivePowerSetpoint(plannedActivePowerSetpoint).withStartupCost(startUpCost).withMarginalCost(marginalCost).withPlannedOutageRate(plannedOutageRate).withForcedOutageRate(forcedOutageRate).add();
    }
}

