/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.InjectionObservability;
import com.powsybl.iidm.network.extensions.InjectionObservabilityAdder;
import com.powsybl.iidm.network.extensions.ObservabilityQuality;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class InjectionObservabilityXmlSerializer<T extends Injection<T>>
extends AbstractExtensionXmlSerializer<T, InjectionObservability<T>> {
    private static final String QUALITY_P = "qualityP";
    private static final String QUALITY_Q = "qualityQ";
    private static final String QUALITY_V = "qualityV";
    private static final String STANDARD_DEVIATION = "standardDeviation";
    private static final String REDUNDANT = "redundant";

    public InjectionObservabilityXmlSerializer() {
        super("injectionObservability", "network", InjectionObservability.class, true, "injectionObservability.xsd", "http://www.itesla_project.eu/schema/iidm/ext/injection_observability/1_0", "io");
    }

    public void write(InjectionObservability<T> injectionObservability, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeOptionalBoolean((String)"observable", (boolean)injectionObservability.isObservable(), (boolean)false, (XMLStreamWriter)context.getWriter());
        this.writeOptionalQuality(QUALITY_P, injectionObservability.getQualityP(), context.getWriter());
        this.writeOptionalQuality(QUALITY_Q, injectionObservability.getQualityQ(), context.getWriter());
        this.writeOptionalQuality(QUALITY_V, injectionObservability.getQualityV(), context.getWriter());
    }

    private void writeOptionalQuality(String elementName, ObservabilityQuality<T> quality, XMLStreamWriter writer) throws XMLStreamException {
        if (quality != null) {
            writer.writeEmptyElement(this.getNamespaceUri(), elementName);
            XmlUtil.writeDouble((String)STANDARD_DEVIATION, (double)quality.getStandardDeviation(), (XMLStreamWriter)writer);
            XmlUtil.writeOptionalBoolean((String)REDUNDANT, (Optional)quality.isRedundant(), (XMLStreamWriter)writer);
        }
    }

    public InjectionObservability<T> read(T identifiable, XmlReaderContext context) throws XMLStreamException {
        boolean observable = XmlUtil.readOptionalBoolAttribute((XMLStreamReader)context.getReader(), (String)"observable", (boolean)false);
        InjectionObservabilityAdder adder = ((InjectionObservabilityAdder)identifiable.newExtension(InjectionObservabilityAdder.class)).withObservable(observable);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            switch (context.getReader().getLocalName()) {
                case "qualityP": {
                    double standardDeviation = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)STANDARD_DEVIATION);
                    boolean redundant = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)REDUNDANT);
                    adder.withStandardDeviationP(standardDeviation).withRedundantP(Boolean.valueOf(redundant));
                    break;
                }
                case "qualityQ": {
                    double standardDeviation = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)STANDARD_DEVIATION);
                    boolean redundant = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)REDUNDANT);
                    adder.withStandardDeviationQ(standardDeviation).withRedundantQ(Boolean.valueOf(redundant));
                    break;
                }
                case "qualityV": {
                    double standardDeviation = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)STANDARD_DEVIATION);
                    boolean redundant = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)REDUNDANT);
                    adder.withStandardDeviationV(standardDeviation).withRedundantV(Boolean.valueOf(redundant));
                    break;
                }
                default: {
                    throw new PowsyblException("Unexpected element: " + context.getReader().getLocalName());
                }
            }
        });
        return (InjectionObservability)adder.add();
    }
}

