/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.extensions.Coordinate;
import com.powsybl.iidm.network.extensions.LinePosition;
import com.powsybl.iidm.network.extensions.LinePositionAdder;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class LinePositionXmlSerializer<T extends Identifiable<T>>
extends AbstractExtensionXmlSerializer<T, LinePosition<T>> {
    public LinePositionXmlSerializer() {
        super("linePosition", "network", LinePosition.class, true, "linePosition.xsd", "http://www.powsybl.org/schema/iidm/ext/line_position/1_0", "lp");
    }

    public void write(LinePosition<T> linePosition, XmlWriterContext context) throws XMLStreamException {
        for (Coordinate point : linePosition.getCoordinates()) {
            context.getWriter().writeEmptyElement(this.getNamespaceUri(), "coordinate");
            XmlUtil.writeDouble((String)"longitude", (double)point.getLongitude(), (XMLStreamWriter)context.getWriter());
            XmlUtil.writeDouble((String)"latitude", (double)point.getLatitude(), (XMLStreamWriter)context.getWriter());
        }
    }

    public LinePosition<T> read(T line, XmlReaderContext context) throws XMLStreamException {
        ArrayList coordinates = new ArrayList();
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            double longitude = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"longitude");
            double latitude = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"latitude");
            coordinates.add(new Coordinate(latitude, longitude));
        });
        LinePositionAdder adder = (LinePositionAdder)line.newExtension(LinePositionAdder.class);
        return (LinePosition)adder.withCoordinates(coordinates).add();
    }
}

