/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadAsymmetrical;
import com.powsybl.iidm.network.extensions.LoadAsymmetricalAdder;
import com.powsybl.iidm.network.extensions.LoadConnectionType;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class LoadAsymmetricalXmlSerializer
extends AbstractExtensionXmlSerializer<Load, LoadAsymmetrical> {
    public LoadAsymmetricalXmlSerializer() {
        super("loadAsymmetrical", "network", LoadAsymmetrical.class, false, "loadAsymmetrical_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/load_asymmetrical/1_0", "las");
    }

    public void write(LoadAsymmetrical loadAsym, XmlWriterContext context) throws XMLStreamException {
        context.getWriter().writeAttribute("connectionType", loadAsym.getConnectionType().name());
        XmlUtil.writeOptionalDouble((String)"deltaPa", (double)loadAsym.getDeltaPa(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"deltaQa", (double)loadAsym.getDeltaQa(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"deltaPb", (double)loadAsym.getDeltaPb(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"deltaQb", (double)loadAsym.getDeltaQb(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"deltaPc", (double)loadAsym.getDeltaPc(), (double)0.0, (XMLStreamWriter)context.getWriter());
        XmlUtil.writeOptionalDouble((String)"deltaQc", (double)loadAsym.getDeltaQc(), (double)0.0, (XMLStreamWriter)context.getWriter());
    }

    public LoadAsymmetrical read(Load load, XmlReaderContext context) throws XMLStreamException {
        LoadConnectionType connectionType = LoadConnectionType.valueOf((String)context.getReader().getAttributeValue(null, "connectionType"));
        double deltaPa = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaPa", (double)0.0);
        double deltaQa = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaQa", (double)0.0);
        double deltaPb = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaPb", (double)0.0);
        double deltaQb = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaQb", (double)0.0);
        double deltaPc = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaPc", (double)0.0);
        double deltaQc = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"deltaQc", (double)0.0);
        return (LoadAsymmetrical)((LoadAsymmetricalAdder)load.newExtension(LoadAsymmetricalAdder.class)).withConnectionType(connectionType).withDeltaPa(deltaPa).withDeltaQa(deltaQa).withDeltaPb(deltaPb).withDeltaQb(deltaQb).withDeltaPc(deltaPc).withDeltaQc(deltaQc).add();
    }
}

