/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.extensions.LoadDetailAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class LoadDetailXmlSerializer
extends AbstractExtensionXmlSerializer<Load, LoadDetail> {
    public LoadDetailXmlSerializer() {
        super("detail", "network", LoadDetail.class, false, "loadDetail.xsd", "http://www.itesla_project.eu/schema/iidm/ext/load_detail/1_0", "ld");
    }

    public void write(LoadDetail detail, XmlWriterContext context) throws XMLStreamException {
        XmlUtil.writeDouble((String)"fixedActivePower", (double)detail.getFixedActivePower(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"fixedReactivePower", (double)detail.getFixedReactivePower(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"variableActivePower", (double)detail.getVariableActivePower(), (XMLStreamWriter)context.getWriter());
        XmlUtil.writeDouble((String)"variableReactivePower", (double)detail.getVariableReactivePower(), (XMLStreamWriter)context.getWriter());
    }

    public LoadDetail read(Load load, XmlReaderContext context) {
        double variableReactivePower;
        double variableActivePower;
        double fixedReactivePower;
        double fixedActivePower = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fixedActivePower");
        if (Double.isNaN(fixedActivePower)) {
            fixedActivePower = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"subLoad1ActivePower");
        }
        if (Double.isNaN(fixedReactivePower = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"fixedReactivePower"))) {
            fixedReactivePower = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"subLoad1ReactivePower");
        }
        if (Double.isNaN(variableActivePower = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"variableActivePower"))) {
            variableActivePower = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"subLoad2ActivePower");
        }
        if (Double.isNaN(variableReactivePower = XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)context.getReader(), (String)"variableReactivePower"))) {
            variableReactivePower = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"subLoad2ReactivePower");
        }
        return (LoadDetail)((LoadDetailAdder)load.newExtension(LoadDetailAdder.class)).withFixedActivePower(fixedActivePower).withFixedReactivePower(fixedReactivePower).withVariableActivePower(variableActivePower).withVariableReactivePower(variableReactivePower).add();
    }
}

