/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.MeasurementAdder;
import com.powsybl.iidm.network.extensions.Measurements;
import com.powsybl.iidm.network.extensions.MeasurementsAdder;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class MeasurementsXmlSerializer<C extends Connectable<C>>
extends AbstractExtensionXmlSerializer<C, Measurements<C>> {
    private static final String MEASUREMENT = "measurement";
    private static final String VALUE = "value";

    public MeasurementsXmlSerializer() {
        super("measurements", "network", Measurements.class, true, "measurements.xsd", "http://www.powsybl.org/schema/iidm/ext/measurements/1_0", "m");
    }

    public void write(Measurements<C> extension, XmlWriterContext context) throws XMLStreamException {
        XMLStreamWriter writer = context.getWriter();
        for (Measurement measurement : extension.getMeasurements()) {
            boolean hasProperty;
            boolean bl = hasProperty = !measurement.getPropertyNames().isEmpty();
            if (hasProperty) {
                writer.writeStartElement(this.getNamespaceUri(), MEASUREMENT);
            } else {
                writer.writeEmptyElement(this.getNamespaceUri(), MEASUREMENT);
            }
            if (measurement.getId() != null) {
                writer.writeAttribute("id", measurement.getId());
            }
            writer.writeAttribute("type", measurement.getType().toString());
            if (measurement.getSide() != null) {
                writer.writeAttribute("side", measurement.getSide().toString());
            }
            XmlUtil.writeDouble((String)VALUE, (double)measurement.getValue(), (XMLStreamWriter)writer);
            XmlUtil.writeDouble((String)"standardDeviation", (double)measurement.getStandardDeviation(), (XMLStreamWriter)writer);
            writer.writeAttribute("valid", String.valueOf(measurement.isValid()));
            for (String name : measurement.getPropertyNames()) {
                writer.writeEmptyElement(this.getNamespaceUri(), "property");
                writer.writeAttribute("name", name);
                writer.writeAttribute(VALUE, measurement.getProperty(name));
            }
            if (!hasProperty) continue;
            writer.writeEndElement();
        }
    }

    public Measurements<C> read(C extendable, XmlReaderContext context) throws XMLStreamException {
        MeasurementsAdder measurementsAdder = (MeasurementsAdder)extendable.newExtension(MeasurementsAdder.class);
        Measurements measurements = (Measurements)measurementsAdder.add();
        XMLStreamReader reader = context.getReader();
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)reader, () -> {
            MeasurementAdder adder;
            if (reader.getLocalName().equals(MEASUREMENT)) {
                adder = measurements.newMeasurement().setId(reader.getAttributeValue(null, "id")).setType(Measurement.Type.valueOf((String)reader.getAttributeValue(null, "type"))).setValue(XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)VALUE)).setStandardDeviation(XmlUtil.readOptionalDoubleAttribute((XMLStreamReader)reader, (String)"standardDeviation")).setValid(XmlUtil.readBoolAttribute((XMLStreamReader)reader, (String)"valid"));
                String side = reader.getAttributeValue(null, "side");
                if (side != null) {
                    adder.setSide(Measurement.Side.valueOf((String)side));
                }
            } else {
                throw new PowsyblException("Unexpected element: " + reader.getLocalName());
            }
            XmlUtil.readUntilEndElement((String)MEASUREMENT, (XMLStreamReader)reader, () -> {
                if (!reader.getLocalName().equals("property")) {
                    throw new PowsyblException("Unexpected element: " + reader.getLocalName());
                }
                adder.putProperty(reader.getAttributeValue(null, "name"), reader.getAttributeValue(null, VALUE));
            });
            adder.add();
        });
        return measurements;
    }

    public boolean isSerializable(Measurements<C> extension) {
        return !extension.getMeasurements().isEmpty();
    }
}

