/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControlAdder;
import com.powsybl.iidm.xml.IidmXmlVersion;
import com.powsybl.iidm.xml.NetworkXmlReaderContext;
import com.powsybl.iidm.xml.NetworkXmlWriterContext;
import com.powsybl.iidm.xml.TerminalRefXml;
import com.powsybl.iidm.xml.util.IidmXmlUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

@AutoService(value={ExtensionXmlSerializer.class})
public class RemoteReactivePowerControlXmlSerializer
extends AbstractExtensionXmlSerializer<Generator, RemoteReactivePowerControl> {
    public RemoteReactivePowerControlXmlSerializer() {
        super("generatorRemoteReactivePowerControl", "network", RemoteReactivePowerControl.class, false, "remoteReactivePowerControl_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/remote_reactive_power_control/1_0", "rrpc");
    }

    public void write(RemoteReactivePowerControl extension, XmlWriterContext context) throws XMLStreamException {
        NetworkXmlWriterContext networkContext = (NetworkXmlWriterContext)context;
        IidmXmlUtil.assertMinimumVersion(this.getName(), IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, networkContext);
        XMLStreamWriter writer = context.getWriter();
        writer.writeAttribute("enabled", Boolean.toString(extension.isEnabled()));
        XmlUtil.writeDouble((String)"targetQ", (double)extension.getTargetQ(), (XMLStreamWriter)writer);
        TerminalRefXml.writeTerminalRefAttribute(extension.getRegulatingTerminal(), networkContext);
    }

    public RemoteReactivePowerControl read(Generator extendable, XmlReaderContext context) throws XMLStreamException {
        NetworkXmlReaderContext networkContext = (NetworkXmlReaderContext)context;
        IidmXmlUtil.assertMinimumVersion(this.getName(), IidmXmlUtil.ErrorMessage.NOT_SUPPORTED, IidmXmlVersion.V_1_5, networkContext);
        boolean enabled = XmlUtil.readBoolAttribute((XMLStreamReader)context.getReader(), (String)"enabled");
        double targetQ = XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetQ");
        Terminal terminal = TerminalRefXml.readTerminal(networkContext, extendable.getNetwork());
        return (RemoteReactivePowerControl)((RemoteReactivePowerControlAdder)extendable.newExtension(RemoteReactivePowerControlAdder.class)).withEnabled(enabled).withTargetQ(targetQ).withRegulatingTerminal(terminal).add();
    }
}

