/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.xml.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionXmlSerializer;
import com.powsybl.commons.extensions.ExtensionXmlSerializer;
import com.powsybl.commons.xml.XmlReaderContext;
import com.powsybl.commons.xml.XmlUtil;
import com.powsybl.commons.xml.XmlWriterContext;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControl;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControlAdder;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.mutable.MutableDouble;

@AutoService(value={ExtensionXmlSerializer.class})
public class SecondaryVoltageControlXmlSerializer
extends AbstractExtensionXmlSerializer<Network, SecondaryVoltageControl> {
    private static final String CONTROL_ZONE_ELEMENT = "controlZone";
    private static final String PILOT_POINT_ELEMENT = "pilotPoint";
    private static final String BUSBAR_SECTION_OR_BUS_ID_ELEMENT = "busbarSectionOrBusId";
    private static final String CONTROL_UNIT_ELEMENT = "controlUnit";

    public SecondaryVoltageControlXmlSerializer() {
        super("secondaryVoltageControl", "network", SecondaryVoltageControl.class, true, "secondaryVoltageControl_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/secondary_voltage_control/1_0", "svc");
    }

    public void write(SecondaryVoltageControl control, XmlWriterContext context) throws XMLStreamException {
        for (SecondaryVoltageControl.ControlZone controlZone : control.getControlZones()) {
            context.getWriter().writeStartElement(this.getNamespaceUri(), CONTROL_ZONE_ELEMENT);
            context.getWriter().writeAttribute("name", controlZone.getName());
            context.getWriter().writeStartElement(this.getNamespaceUri(), PILOT_POINT_ELEMENT);
            XmlUtil.writeDouble((String)"targetV", (double)controlZone.getPilotPoint().getTargetV(), (XMLStreamWriter)context.getWriter());
            for (String busbarSectionOrBusId : controlZone.getPilotPoint().getBusbarSectionsOrBusesIds()) {
                context.getWriter().writeStartElement(this.getNamespaceUri(), BUSBAR_SECTION_OR_BUS_ID_ELEMENT);
                context.getWriter().writeCharacters(busbarSectionOrBusId);
                context.getWriter().writeEndElement();
            }
            context.getWriter().writeEndElement();
            for (SecondaryVoltageControl.ControlUnit controlUnit : controlZone.getControlUnits()) {
                context.getWriter().writeStartElement(this.getNamespaceUri(), CONTROL_UNIT_ELEMENT);
                context.getWriter().writeAttribute("participate", Boolean.toString(controlUnit.isParticipate()));
                context.getWriter().writeCharacters(controlUnit.getId());
                context.getWriter().writeEndElement();
            }
            context.getWriter().writeEndElement();
        }
    }

    public SecondaryVoltageControl read(Network network, XmlReaderContext context) throws XMLStreamException {
        SecondaryVoltageControlAdder adder = (SecondaryVoltageControlAdder)network.newExtension(SecondaryVoltageControlAdder.class);
        XmlUtil.readUntilEndElement((String)this.getExtensionName(), (XMLStreamReader)context.getReader(), () -> {
            if (context.getReader().getLocalName().equals(CONTROL_ZONE_ELEMENT)) {
                String name = context.getReader().getAttributeValue(null, "name");
                MutableDouble targetV = new MutableDouble(Double.NaN);
                ArrayList busbarSectionsOrBusesIds = new ArrayList();
                ArrayList controlUnits = new ArrayList();
                XmlUtil.readUntilEndElement((String)CONTROL_ZONE_ELEMENT, (XMLStreamReader)context.getReader(), () -> {
                    if (context.getReader().getLocalName().equals(PILOT_POINT_ELEMENT)) {
                        targetV.setValue(XmlUtil.readDoubleAttribute((XMLStreamReader)context.getReader(), (String)"targetV"));
                    } else if (context.getReader().getLocalName().equals(BUSBAR_SECTION_OR_BUS_ID_ELEMENT)) {
                        busbarSectionsOrBusesIds.add(XmlUtil.readText((String)BUSBAR_SECTION_OR_BUS_ID_ELEMENT, (XMLStreamReader)context.getReader()));
                    } else if (context.getReader().getLocalName().equals(CONTROL_UNIT_ELEMENT)) {
                        boolean participate = Boolean.parseBoolean(context.getReader().getAttributeValue(null, "participate"));
                        String id = XmlUtil.readText((String)CONTROL_UNIT_ELEMENT, (XMLStreamReader)context.getReader());
                        controlUnits.add(new SecondaryVoltageControl.ControlUnit(id, participate));
                    } else {
                        throw new IllegalStateException("Unexpected element " + context.getReader().getLocalName());
                    }
                });
                SecondaryVoltageControl.PilotPoint pilotPoint = new SecondaryVoltageControl.PilotPoint(busbarSectionsOrBusesIds, targetV.getValue().doubleValue());
                adder.addControlZone(new SecondaryVoltageControl.ControlZone(name, pilotPoint, controlUnits));
            }
        });
        return (SecondaryVoltageControl)adder.add();
    }
}

